import { PartialRecord } from '../typescript-tools'
import { canBeBrouillon, ETAPES_TYPES, isEtapeDecision, isEtapeTypeId, isEtapeTypeIdFondamentale, isEtapeWithAutomaticStatuts } from './etapesTypes'
import { test, expect } from 'vitest'

test('isEtapeTypeId', () => {
  expect(isEtapeTypeId('aaaaa')).toBe(false)
  expect(isEtapeTypeId('mfr')).toBe(true)
})

test('isEtapeTypeIdFondamentale', () => {
  const result = Object.entries(ETAPES_TYPES).reduce<PartialRecord<string, boolean>>((acc, [etapeTypeLabel, etapeTypeId]) => {
    acc[etapeTypeLabel] = isEtapeTypeIdFondamentale(etapeTypeId)

    return acc
  }, {})
  expect(result).toMatchInlineSnapshot(`
    {
      "abrogationDeLaDecision": true,
      "arreteDePrescriptionsComplementaires": false,
      "arreteDeSecondDonnerActe": false,
      "arreteDouvertureDesTravauxMiniers": false,
      "arretePrefectoralDePremierDonnerActe_DADT_": false,
      "arretePrefectoralDeSursisAStatuer": false,
      "attestationDeConstitutionDeGarantiesFinancieres": false,
      "avenantALautorisationDeRechercheMiniere": true,
      "avisDeDemandeConcurrente": false,
      "avisDeLaCommissionDepartementaleDesMines_CDM_": false,
      "avisDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_": true,
      "avisDeLautoriteEnvironnementale": false,
      "avisDeMiseEnConcurrenceAuJORF": true,
      "avisDeReception": false,
      "avisDesCollectivites": false,
      "avisDesServicesEtCommissionsConsultatives": false,
      "avisDuConseilDEtat": false,
      "avisDuConseilGeneralDeLeconomie_CGE_": false,
      "avisDuDemandeurSurLesPrescriptionsProposees": false,
      "avisDuPrefet": false,
      "classementSansSuite": false,
      "completudeDeLaDemande": false,
      "consultationDesAdministrationsCentrales": false,
      "decisionDeLAutoriteAdministrative": true,
      "decisionDeLOfficeNationalDesForets": true,
      "decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_": false,
      "decisionDuJugeAdministratif": true,
      "declarationDIrrecevabilite": false,
      "declarationDarretDefinitifDeTravaux_DADT_": false,
      "declarationDouvertureDeTravauxMiniers_DOTM_": false,
      "demande": true,
      "demandeDautorisationDouvertureDeTravauxMiniers_AOTM_": false,
      "demandeDeComplements": false,
      "demandeDeComplements_AOTMOuDOTM_": false,
      "demandeDeComplements_CompletudeDeLaDemande_": false,
      "demandeDeComplements_DADT_": false,
      "demandeDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_": false,
      "demandeDeComplements_RecepisseDeDeclarationLoiSurLeau_": false,
      "demandeDeComplements_RecevabiliteDeLaDemande_": false,
      "demandeDeComplements_SaisineDeLaCARM_": false,
      "demandeDeConsentement": false,
      "demandeDeModificationAES": false,
      "demandeDinformations": false,
      "demandeDinformations_AvisDuDREALDEALOuDGTM_": false,
      "demandeDinformations_RecevabiliteDeLaDemande_": false,
      "depotDeLaDemande_wdd": false,
      "desistementDuDemandeur": false,
      "donneActeDeLaDeclaration_DOTM_": false,
      "enquetePublique": false,
      "enregistrementDeLaDemande": false,
      "expertises": false,
      "informationDuPrefetEtDesCollectivites": false,
      "informationsHistoriquesIncompletes": true,
      "memoireDeFinDeTravaux": false,
      "mesuresDePublicite": false,
      "modificationDeLaDemande": true,
      "notificationAuDemandeur": false,
      "notificationAuDemandeur_AjournementDeLaCARM_": false,
      "notificationAuDemandeur_AvisDefavorable_": false,
      "notificationAuDemandeur_AvisFavorableDeLaCARM_": false,
      "notificationAuDemandeur_ClassementSansSuite_": false,
      "notificationAuDemandeur_InitiationDeLaDemarcheDeRetrait_": false,
      "notificationAuDemandeur_SignatureDeLautorisationDeRechercheMiniere_": false,
      "notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_": false,
      "notificationDesCollectivitesLocales": false,
      "paiementDesFraisDeDossier": false,
      "paiementDesFraisDeDossierComplementaires": false,
      "participationDuPublic": false,
      "porterAConnaissance": false,
      "priseEnChargeParLOfficeNationalDesForets": false,
      "publicationDansUnJournalLocalOuNational": false,
      "publicationDeDecisionAuJORF": true,
      "publicationDeDecisionAuRecueilDesActesAdministratifs": true,
      "publicationDeLavisDeDecisionImplicite": false,
      "rapportDuConseilDEtat": false,
      "rapportDuConseilGeneralDeLeconomie_CGE_": false,
      "rapportEtAvisDeLaDREAL": false,
      "recepisseDeDeclarationLoiSurLeau": false,
      "receptionDeComplements": true,
      "receptionDeComplements_CompletudeDeLaDemande_": true,
      "receptionDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet__": true,
      "receptionDeComplements_RecepisseDeDeclarationLoiSurLeau_": true,
      "receptionDeComplements_RecevabiliteDeLaDemande_": true,
      "receptionDeComplements_SaisineDeLaCARM_": true,
      "receptionDeComplements_wrc": false,
      "receptionDinformation": true,
      "recevabiliteDeLaDemande": false,
      "recolement": false,
      "reponseDuDemandeur": false,
      "resultatMiseEnConcurrence": true,
      "saisineDeLaCommissionDepartementaleDesMines_CDM_": false,
      "saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_": false,
      "saisineDeLautoriteEnvironnementale": false,
      "saisineDeLautoriteSignataire": false,
      "saisineDuConseilDEtat": false,
      "saisineDuConseilGeneralDeLeconomie_CGE_": false,
      "saisineDuPrefet": false,
      "signatureDeLautorisationDeRechercheMiniere": true,
      "transmissionDuProjetDePrescriptionsAuDemandeur": false,
      "validationDuPaiementDesFraisDeDossier": false,
      "validationDuPaiementDesFraisDeDossierComplementaires": false,
    }
  `)
})
test('canBeBrouillon', () => {
  const result = Object.entries(ETAPES_TYPES).reduce<PartialRecord<string, boolean>>((acc, [etapeTypeLabel, etapeTypeId]) => {
    acc[etapeTypeLabel] = canBeBrouillon(etapeTypeId)

    return acc
  }, {})
  expect(result).toMatchInlineSnapshot(`
    {
      "abrogationDeLaDecision": false,
      "arreteDePrescriptionsComplementaires": false,
      "arreteDeSecondDonnerActe": false,
      "arreteDouvertureDesTravauxMiniers": false,
      "arretePrefectoralDePremierDonnerActe_DADT_": false,
      "arretePrefectoralDeSursisAStatuer": false,
      "attestationDeConstitutionDeGarantiesFinancieres": false,
      "avenantALautorisationDeRechercheMiniere": false,
      "avisDeDemandeConcurrente": false,
      "avisDeLaCommissionDepartementaleDesMines_CDM_": false,
      "avisDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_": false,
      "avisDeLautoriteEnvironnementale": false,
      "avisDeMiseEnConcurrenceAuJORF": false,
      "avisDeReception": false,
      "avisDesCollectivites": true,
      "avisDesServicesEtCommissionsConsultatives": true,
      "avisDuConseilDEtat": false,
      "avisDuConseilGeneralDeLeconomie_CGE_": true,
      "avisDuDemandeurSurLesPrescriptionsProposees": false,
      "avisDuPrefet": false,
      "classementSansSuite": false,
      "completudeDeLaDemande": false,
      "consultationDesAdministrationsCentrales": true,
      "decisionDeLAutoriteAdministrative": false,
      "decisionDeLOfficeNationalDesForets": false,
      "decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_": false,
      "decisionDuJugeAdministratif": false,
      "declarationDIrrecevabilite": false,
      "declarationDarretDefinitifDeTravaux_DADT_": false,
      "declarationDouvertureDeTravauxMiniers_DOTM_": false,
      "demande": true,
      "demandeDautorisationDouvertureDeTravauxMiniers_AOTM_": false,
      "demandeDeComplements": false,
      "demandeDeComplements_AOTMOuDOTM_": false,
      "demandeDeComplements_CompletudeDeLaDemande_": false,
      "demandeDeComplements_DADT_": false,
      "demandeDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_": false,
      "demandeDeComplements_RecepisseDeDeclarationLoiSurLeau_": false,
      "demandeDeComplements_RecevabiliteDeLaDemande_": false,
      "demandeDeComplements_SaisineDeLaCARM_": false,
      "demandeDeConsentement": false,
      "demandeDeModificationAES": false,
      "demandeDinformations": false,
      "demandeDinformations_AvisDuDREALDEALOuDGTM_": false,
      "demandeDinformations_RecevabiliteDeLaDemande_": false,
      "depotDeLaDemande_wdd": false,
      "desistementDuDemandeur": false,
      "donneActeDeLaDeclaration_DOTM_": false,
      "enquetePublique": false,
      "enregistrementDeLaDemande": false,
      "expertises": false,
      "informationDuPrefetEtDesCollectivites": false,
      "informationsHistoriquesIncompletes": false,
      "memoireDeFinDeTravaux": false,
      "mesuresDePublicite": false,
      "modificationDeLaDemande": false,
      "notificationAuDemandeur": false,
      "notificationAuDemandeur_AjournementDeLaCARM_": false,
      "notificationAuDemandeur_AvisDefavorable_": false,
      "notificationAuDemandeur_AvisFavorableDeLaCARM_": false,
      "notificationAuDemandeur_ClassementSansSuite_": false,
      "notificationAuDemandeur_InitiationDeLaDemarcheDeRetrait_": false,
      "notificationAuDemandeur_SignatureDeLautorisationDeRechercheMiniere_": false,
      "notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_": false,
      "notificationDesCollectivitesLocales": false,
      "paiementDesFraisDeDossier": false,
      "paiementDesFraisDeDossierComplementaires": false,
      "participationDuPublic": true,
      "porterAConnaissance": false,
      "priseEnChargeParLOfficeNationalDesForets": false,
      "publicationDansUnJournalLocalOuNational": false,
      "publicationDeDecisionAuJORF": false,
      "publicationDeDecisionAuRecueilDesActesAdministratifs": false,
      "publicationDeLavisDeDecisionImplicite": false,
      "rapportDuConseilDEtat": false,
      "rapportDuConseilGeneralDeLeconomie_CGE_": false,
      "rapportEtAvisDeLaDREAL": false,
      "recepisseDeDeclarationLoiSurLeau": false,
      "receptionDeComplements": true,
      "receptionDeComplements_CompletudeDeLaDemande_": false,
      "receptionDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet__": false,
      "receptionDeComplements_RecepisseDeDeclarationLoiSurLeau_": false,
      "receptionDeComplements_RecevabiliteDeLaDemande_": false,
      "receptionDeComplements_SaisineDeLaCARM_": false,
      "receptionDeComplements_wrc": false,
      "receptionDinformation": true,
      "recevabiliteDeLaDemande": false,
      "recolement": false,
      "reponseDuDemandeur": true,
      "resultatMiseEnConcurrence": false,
      "saisineDeLaCommissionDepartementaleDesMines_CDM_": false,
      "saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_": false,
      "saisineDeLautoriteEnvironnementale": false,
      "saisineDeLautoriteSignataire": false,
      "saisineDuConseilDEtat": false,
      "saisineDuConseilGeneralDeLeconomie_CGE_": false,
      "saisineDuPrefet": false,
      "signatureDeLautorisationDeRechercheMiniere": false,
      "transmissionDuProjetDePrescriptionsAuDemandeur": false,
      "validationDuPaiementDesFraisDeDossier": false,
      "validationDuPaiementDesFraisDeDossierComplementaires": false,
    }
  `)
})
test('isEtapeDecision', () => {
  const result = Object.entries(ETAPES_TYPES).reduce<PartialRecord<string, boolean>>((acc, [etapeTypeLabel, etapeTypeId]) => {
    acc[etapeTypeLabel] = isEtapeDecision(etapeTypeId)

    return acc
  }, {})
  expect(result).toMatchInlineSnapshot(`
    {
      "abrogationDeLaDecision": false,
      "arreteDePrescriptionsComplementaires": false,
      "arreteDeSecondDonnerActe": false,
      "arreteDouvertureDesTravauxMiniers": false,
      "arretePrefectoralDePremierDonnerActe_DADT_": false,
      "arretePrefectoralDeSursisAStatuer": false,
      "attestationDeConstitutionDeGarantiesFinancieres": false,
      "avenantALautorisationDeRechercheMiniere": true,
      "avisDeDemandeConcurrente": false,
      "avisDeLaCommissionDepartementaleDesMines_CDM_": false,
      "avisDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_": false,
      "avisDeLautoriteEnvironnementale": false,
      "avisDeMiseEnConcurrenceAuJORF": false,
      "avisDeReception": false,
      "avisDesCollectivites": false,
      "avisDesServicesEtCommissionsConsultatives": false,
      "avisDuConseilDEtat": false,
      "avisDuConseilGeneralDeLeconomie_CGE_": false,
      "avisDuDemandeurSurLesPrescriptionsProposees": false,
      "avisDuPrefet": false,
      "classementSansSuite": false,
      "completudeDeLaDemande": false,
      "consultationDesAdministrationsCentrales": false,
      "decisionDeLAutoriteAdministrative": true,
      "decisionDeLOfficeNationalDesForets": true,
      "decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_": false,
      "decisionDuJugeAdministratif": false,
      "declarationDIrrecevabilite": false,
      "declarationDarretDefinitifDeTravaux_DADT_": false,
      "declarationDouvertureDeTravauxMiniers_DOTM_": false,
      "demande": false,
      "demandeDautorisationDouvertureDeTravauxMiniers_AOTM_": false,
      "demandeDeComplements": false,
      "demandeDeComplements_AOTMOuDOTM_": false,
      "demandeDeComplements_CompletudeDeLaDemande_": false,
      "demandeDeComplements_DADT_": false,
      "demandeDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_": false,
      "demandeDeComplements_RecepisseDeDeclarationLoiSurLeau_": false,
      "demandeDeComplements_RecevabiliteDeLaDemande_": false,
      "demandeDeComplements_SaisineDeLaCARM_": false,
      "demandeDeConsentement": false,
      "demandeDeModificationAES": false,
      "demandeDinformations": false,
      "demandeDinformations_AvisDuDREALDEALOuDGTM_": false,
      "demandeDinformations_RecevabiliteDeLaDemande_": false,
      "depotDeLaDemande_wdd": false,
      "desistementDuDemandeur": false,
      "donneActeDeLaDeclaration_DOTM_": false,
      "enquetePublique": false,
      "enregistrementDeLaDemande": false,
      "expertises": false,
      "informationDuPrefetEtDesCollectivites": false,
      "informationsHistoriquesIncompletes": false,
      "memoireDeFinDeTravaux": false,
      "mesuresDePublicite": false,
      "modificationDeLaDemande": false,
      "notificationAuDemandeur": false,
      "notificationAuDemandeur_AjournementDeLaCARM_": false,
      "notificationAuDemandeur_AvisDefavorable_": false,
      "notificationAuDemandeur_AvisFavorableDeLaCARM_": false,
      "notificationAuDemandeur_ClassementSansSuite_": false,
      "notificationAuDemandeur_InitiationDeLaDemarcheDeRetrait_": false,
      "notificationAuDemandeur_SignatureDeLautorisationDeRechercheMiniere_": false,
      "notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_": false,
      "notificationDesCollectivitesLocales": false,
      "paiementDesFraisDeDossier": false,
      "paiementDesFraisDeDossierComplementaires": false,
      "participationDuPublic": false,
      "porterAConnaissance": false,
      "priseEnChargeParLOfficeNationalDesForets": false,
      "publicationDansUnJournalLocalOuNational": false,
      "publicationDeDecisionAuJORF": true,
      "publicationDeDecisionAuRecueilDesActesAdministratifs": true,
      "publicationDeLavisDeDecisionImplicite": false,
      "rapportDuConseilDEtat": false,
      "rapportDuConseilGeneralDeLeconomie_CGE_": false,
      "rapportEtAvisDeLaDREAL": false,
      "recepisseDeDeclarationLoiSurLeau": false,
      "receptionDeComplements": false,
      "receptionDeComplements_CompletudeDeLaDemande_": false,
      "receptionDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet__": false,
      "receptionDeComplements_RecepisseDeDeclarationLoiSurLeau_": false,
      "receptionDeComplements_RecevabiliteDeLaDemande_": false,
      "receptionDeComplements_SaisineDeLaCARM_": false,
      "receptionDeComplements_wrc": false,
      "receptionDinformation": false,
      "recevabiliteDeLaDemande": false,
      "recolement": false,
      "reponseDuDemandeur": false,
      "resultatMiseEnConcurrence": false,
      "saisineDeLaCommissionDepartementaleDesMines_CDM_": false,
      "saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_": false,
      "saisineDeLautoriteEnvironnementale": false,
      "saisineDeLautoriteSignataire": false,
      "saisineDuConseilDEtat": false,
      "saisineDuConseilGeneralDeLeconomie_CGE_": false,
      "saisineDuPrefet": false,
      "signatureDeLautorisationDeRechercheMiniere": true,
      "transmissionDuProjetDePrescriptionsAuDemandeur": false,
      "validationDuPaiementDesFraisDeDossier": false,
      "validationDuPaiementDesFraisDeDossierComplementaires": false,
    }
  `)
})

test('isEtapeWithAutomaticStatuts', () => {
  const result = Object.entries(ETAPES_TYPES).reduce<PartialRecord<string, boolean>>((acc, [etapeTypeLabel, etapeTypeId]) => {
    acc[etapeTypeLabel] = isEtapeWithAutomaticStatuts(etapeTypeId)

    return acc
  }, {})
  expect(result).toMatchInlineSnapshot(`
    {
      "abrogationDeLaDecision": false,
      "arreteDePrescriptionsComplementaires": false,
      "arreteDeSecondDonnerActe": false,
      "arreteDouvertureDesTravauxMiniers": false,
      "arretePrefectoralDePremierDonnerActe_DADT_": false,
      "arretePrefectoralDeSursisAStatuer": false,
      "attestationDeConstitutionDeGarantiesFinancieres": false,
      "avenantALautorisationDeRechercheMiniere": false,
      "avisDeDemandeConcurrente": false,
      "avisDeLaCommissionDepartementaleDesMines_CDM_": false,
      "avisDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_": false,
      "avisDeLautoriteEnvironnementale": false,
      "avisDeMiseEnConcurrenceAuJORF": true,
      "avisDeReception": false,
      "avisDesCollectivites": false,
      "avisDesServicesEtCommissionsConsultatives": false,
      "avisDuConseilDEtat": false,
      "avisDuConseilGeneralDeLeconomie_CGE_": false,
      "avisDuDemandeurSurLesPrescriptionsProposees": false,
      "avisDuPrefet": false,
      "classementSansSuite": false,
      "completudeDeLaDemande": false,
      "consultationDesAdministrationsCentrales": false,
      "decisionDeLAutoriteAdministrative": false,
      "decisionDeLOfficeNationalDesForets": false,
      "decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_": false,
      "decisionDuJugeAdministratif": false,
      "declarationDIrrecevabilite": false,
      "declarationDarretDefinitifDeTravaux_DADT_": false,
      "declarationDouvertureDeTravauxMiniers_DOTM_": false,
      "demande": false,
      "demandeDautorisationDouvertureDeTravauxMiniers_AOTM_": false,
      "demandeDeComplements": false,
      "demandeDeComplements_AOTMOuDOTM_": false,
      "demandeDeComplements_CompletudeDeLaDemande_": false,
      "demandeDeComplements_DADT_": false,
      "demandeDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_": false,
      "demandeDeComplements_RecepisseDeDeclarationLoiSurLeau_": false,
      "demandeDeComplements_RecevabiliteDeLaDemande_": false,
      "demandeDeComplements_SaisineDeLaCARM_": false,
      "demandeDeConsentement": false,
      "demandeDeModificationAES": false,
      "demandeDinformations": false,
      "demandeDinformations_AvisDuDREALDEALOuDGTM_": false,
      "demandeDinformations_RecevabiliteDeLaDemande_": false,
      "depotDeLaDemande_wdd": false,
      "desistementDuDemandeur": false,
      "donneActeDeLaDeclaration_DOTM_": false,
      "enquetePublique": true,
      "enregistrementDeLaDemande": false,
      "expertises": false,
      "informationDuPrefetEtDesCollectivites": false,
      "informationsHistoriquesIncompletes": false,
      "memoireDeFinDeTravaux": false,
      "mesuresDePublicite": false,
      "modificationDeLaDemande": false,
      "notificationAuDemandeur": false,
      "notificationAuDemandeur_AjournementDeLaCARM_": false,
      "notificationAuDemandeur_AvisDefavorable_": false,
      "notificationAuDemandeur_AvisFavorableDeLaCARM_": false,
      "notificationAuDemandeur_ClassementSansSuite_": false,
      "notificationAuDemandeur_InitiationDeLaDemarcheDeRetrait_": false,
      "notificationAuDemandeur_SignatureDeLautorisationDeRechercheMiniere_": false,
      "notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_": false,
      "notificationDesCollectivitesLocales": false,
      "paiementDesFraisDeDossier": false,
      "paiementDesFraisDeDossierComplementaires": false,
      "participationDuPublic": true,
      "porterAConnaissance": false,
      "priseEnChargeParLOfficeNationalDesForets": false,
      "publicationDansUnJournalLocalOuNational": false,
      "publicationDeDecisionAuJORF": false,
      "publicationDeDecisionAuRecueilDesActesAdministratifs": false,
      "publicationDeLavisDeDecisionImplicite": false,
      "rapportDuConseilDEtat": false,
      "rapportDuConseilGeneralDeLeconomie_CGE_": false,
      "rapportEtAvisDeLaDREAL": false,
      "recepisseDeDeclarationLoiSurLeau": false,
      "receptionDeComplements": false,
      "receptionDeComplements_CompletudeDeLaDemande_": false,
      "receptionDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet__": false,
      "receptionDeComplements_RecepisseDeDeclarationLoiSurLeau_": false,
      "receptionDeComplements_RecevabiliteDeLaDemande_": false,
      "receptionDeComplements_SaisineDeLaCARM_": false,
      "receptionDeComplements_wrc": false,
      "receptionDinformation": false,
      "recevabiliteDeLaDemande": false,
      "recolement": false,
      "reponseDuDemandeur": false,
      "resultatMiseEnConcurrence": false,
      "saisineDeLaCommissionDepartementaleDesMines_CDM_": false,
      "saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_": false,
      "saisineDeLautoriteEnvironnementale": false,
      "saisineDeLautoriteSignataire": false,
      "saisineDuConseilDEtat": false,
      "saisineDuConseilGeneralDeLeconomie_CGE_": false,
      "saisineDuPrefet": false,
      "signatureDeLautorisationDeRechercheMiniere": false,
      "transmissionDuProjetDePrescriptionsAuDemandeur": false,
      "validationDuPaiementDesFraisDeDossier": false,
      "validationDuPaiementDesFraisDeDossierComplementaires": false,
    }
  `)
})
