import { getKeys, isNotNullNorUndefined } from '../typescript-tools'
import { AdministrationId, ADMINISTRATION_IDS } from './administrations'
import { EtapeTypeId, ETAPES_TYPES, isEtapeTypeId } from './etapesTypes'
import { isTitreType, TITRES_TYPES_IDS, TitreTypeId } from './titresTypes'

// TODO 2023-01-24: on n'a exposé uniquement creationInterdit
const restrictions = (
  administrationId: AdministrationId,
  titreTypeId: TitreTypeId,
  etapeTypeId: EtapeTypeId
): {
  lectureInterdit: boolean
  creationInterdit: boolean
  modificationInterdit: boolean
} => {
  const restriction = AdministrationsTitresTypesEtapesTypes[administrationId]?.[titreTypeId]?.[etapeTypeId]

  if (restriction !== undefined) {
    return restriction
  }

  return { lectureInterdit: false, creationInterdit: false, modificationInterdit: false }
}

export const canAdministrationEtapeTypeId = (administrationId: AdministrationId, titreTypeId: TitreTypeId, etapeTypeId: EtapeTypeId, permission: 'creation' | 'modification'): boolean => {
  return !restrictions(administrationId, titreTypeId, etapeTypeId)[`${permission}Interdit`]
}

const AdministrationsTitresTypesEtapesTypes: {
  [key in AdministrationId]?: {
    [key in TitreTypeId]?: {
      [key in EtapeTypeId]?: {
        lectureInterdit: boolean
        creationInterdit: boolean
        modificationInterdit: boolean
      }
    }
  }
} = {
  [ADMINISTRATION_IDS['GENDARMERIE NATIONALE - GUYANE']]: {
    [TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX]: {
      [ETAPES_TYPES.avisDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avenantALautorisationDeRechercheMiniere]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLOfficeNationalDesForets]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.expertises]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_RecepisseDeDeclarationLoiSurLeau_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.completudeDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.recevabiliteDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_SaisineDeLaCARM_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.priseEnChargeParLOfficeNationalDesForets]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDinformations]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AjournementDeLaCARM_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AvisFavorableDeLaCARM_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_ClassementSansSuite_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AvisDefavorable_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_SignatureDeLautorisationDeRechercheMiniere_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.modificationDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.paiementDesFraisDeDossierComplementaires]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.paiementDesFraisDeDossier]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet__]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_CompletudeDeLaDemande_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_SaisineDeLaCARM_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.recepisseDeDeclarationLoiSurLeau]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDinformation]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.signatureDeLautorisationDeRechercheMiniere]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.validationDuPaiementDesFraisDeDossierComplementaires]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.validationDuPaiementDesFraisDeDossier]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
    },
  },
  [ADMINISTRATION_IDS['MRAE GUYANE']]: {
    [TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX]: {
      [ETAPES_TYPES.avisDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avenantALautorisationDeRechercheMiniere]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.decisionDeLOfficeNationalDesForets]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_RecepisseDeDeclarationLoiSurLeau_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_CompletudeDeLaDemande_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.completudeDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.recevabiliteDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_SaisineDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.priseEnChargeParLOfficeNationalDesForets]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDinformations]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDinformations_RecevabiliteDeLaDemande_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AjournementDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AvisFavorableDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_ClassementSansSuite_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AvisDefavorable_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_SignatureDeLautorisationDeRechercheMiniere_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.modificationDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.paiementDesFraisDeDossierComplementaires]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.paiementDesFraisDeDossier]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_RecepisseDeDeclarationLoiSurLeau_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet__]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_CompletudeDeLaDemande_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_SaisineDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.recepisseDeDeclarationLoiSurLeau]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDinformation]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.signatureDeLautorisationDeRechercheMiniere]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.validationDuPaiementDesFraisDeDossierComplementaires]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.validationDuPaiementDesFraisDeDossier]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
  },
  [ADMINISTRATION_IDS['DGTM - GUYANE']]: {
    [TITRES_TYPES_IDS.CONCESSION_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
    [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeLavisDeDecisionImplicite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
  },
  [ADMINISTRATION_IDS['DREAL - AUVERGNE-RHÔNE-ALPES - SIÈGE DE LYON']]: {
    [TITRES_TYPES_IDS.CONCESSION_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
    [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeLavisDeDecisionImplicite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
  },
  [ADMINISTRATION_IDS['DREAL - BOURGOGNE-FRANCHE-COMTÉ - SIÈGE DE BESANÇON']]: {
    [TITRES_TYPES_IDS.CONCESSION_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
    [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeLavisDeDecisionImplicite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
  },
  [ADMINISTRATION_IDS['DREAL - GRAND EST - SIÈGE DE METZ']]: {
    [TITRES_TYPES_IDS.CONCESSION_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
    [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeLavisDeDecisionImplicite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
  },
  [ADMINISTRATION_IDS['DREAL - OCCITANIE - SIÈGE DE TOULOUSE']]: {
    [TITRES_TYPES_IDS.CONCESSION_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilDEtat]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
    [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_METAUX]: {
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeLavisDeDecisionImplicite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDeDecisionAuJORF]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeDemandeConcurrente]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationDuPrefetEtDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.participationDuPublic]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuConseilGeneralDeLeconomie_CGE_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDuPrefet]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
  },
  [ADMINISTRATION_IDS['OFFICE NATIONAL DES FORÊTS']]: {
    [TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX]: {
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.expertises]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.completudeDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.recevabiliteDeLaDemande]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDinformations]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.demandeDinformations_RecevabiliteDeLaDemande_]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.modificationDeLaDemande]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.receptionDinformation]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
    },
    [TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX]: {
      [ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.abrogationDeLaDecision]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDesCollectivites]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDuJugeAdministratif]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.rapportEtAvisDeLaDREAL]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLAutoriteAdministrative]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.informationsHistoriquesIncompletes]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_RecevabiliteDeLaDemande_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.recevabiliteDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.demandeDinformations_AvisDuDREALDEALOuDGTM_]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.demandeDinformations]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.notificationAuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.modificationDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationDesCollectivitesLocales]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.publicationDansUnJournalLocalOuNational]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_RecevabiliteDeLaDemande_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDinformation]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLautoriteSignataire]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
    [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_METAUX]: {
      [ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
  },
  [ADMINISTRATION_IDS['PÔLE TECHNIQUE MINIER DE GUYANE']]: {
    [TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX]: {
      [ETAPES_TYPES.avisDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avenantALautorisationDeRechercheMiniere]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.decisionDeLOfficeNationalDesForets]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.expertises]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.completudeDeLaDemande]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.recevabiliteDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.priseEnChargeParLOfficeNationalDesForets]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDinformations]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDinformations_RecevabiliteDeLaDemande_]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AjournementDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AvisFavorableDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_ClassementSansSuite_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AvisDefavorable_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_SignatureDeLautorisationDeRechercheMiniere_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.modificationDeLaDemande]: { lectureInterdit: false, creationInterdit: false, modificationInterdit: false },
      [ETAPES_TYPES.paiementDesFraisDeDossierComplementaires]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.recepisseDeDeclarationLoiSurLeau]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDinformation]: { lectureInterdit: true, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.signatureDeLautorisationDeRechercheMiniere]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.validationDuPaiementDesFraisDeDossierComplementaires]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.validationDuPaiementDesFraisDeDossier]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
  },
  [ADMINISTRATION_IDS['PRÉFECTURE - GUYANE']]: {
    [TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX]: {
      [ETAPES_TYPES.avisDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avenantALautorisationDeRechercheMiniere]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.classementSansSuite]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.decisionDeLOfficeNationalDesForets]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.desistementDuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_RecepisseDeDeclarationLoiSurLeau_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_CompletudeDeLaDemande_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.completudeDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.recevabiliteDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDeComplements_SaisineDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.enregistrementDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.priseEnChargeParLOfficeNationalDesForets]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDinformations]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.demandeDinformations_RecevabiliteDeLaDemande_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AjournementDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AvisFavorableDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_ClassementSansSuite_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_AvisDefavorable_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_SignatureDeLautorisationDeRechercheMiniere_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.modificationDeLaDemande]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.paiementDesFraisDeDossierComplementaires]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.paiementDesFraisDeDossier]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_RecepisseDeDeclarationLoiSurLeau_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet__]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_CompletudeDeLaDemande_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDeComplements_SaisineDeLaCARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.recepisseDeDeclarationLoiSurLeau]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.receptionDinformation]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.signatureDeLautorisationDeRechercheMiniere]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.validationDuPaiementDesFraisDeDossierComplementaires]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
      [ETAPES_TYPES.validationDuPaiementDesFraisDeDossier]: { lectureInterdit: false, creationInterdit: true, modificationInterdit: true },
    },
  },
}

export const getAdministrationTitresTypesEtapesTypes = (
  administrationId: AdministrationId
): { titreTypeId: TitreTypeId; etapeTypeId: EtapeTypeId; lectureInterdit: boolean; creationInterdit: boolean; modificationInterdit: boolean }[] => {
  return getKeys(AdministrationsTitresTypesEtapesTypes[administrationId] ?? {}, isTitreType)
    .flatMap(titreTypeId =>
      // waiting for typescript improvement
      /* v8 ignore next */
      getKeys(AdministrationsTitresTypesEtapesTypes[administrationId]?.[titreTypeId] ?? {}, isEtapeTypeId).flatMap(etapeTypeId => {
        const value = AdministrationsTitresTypesEtapesTypes[administrationId]?.[titreTypeId]?.[etapeTypeId]

        return value
          ? {
              titreTypeId,
              etapeTypeId,
              lectureInterdit: value.lectureInterdit,
              creationInterdit: value.creationInterdit,
              modificationInterdit: value.modificationInterdit,
              // waiting for typescript improvement
              /* v8 ignore next 2 */
            }
          : undefined
      })
    )
    .filter(isNotNullNorUndefined)
}
