import { canAdministrationEtapeTypeId, getAdministrationTitresTypesEtapesTypes } from './administrationsTitresTypesEtapesTypes'
import { test, expect } from 'vitest'

test('canAdministrationEtapeTypeId', () => {
  expect(canAdministrationEtapeTypeId('aut-mrae-guyane-01', 'arm', 'dae', 'creation')).toBe(true)
  expect(canAdministrationEtapeTypeId('dea-guyane-01', 'cxm', 'mfr', 'modification')).toBe(false)
})
test('getAdministrationTitresTypesEtapesTypes', () => {
  expect(getAdministrationTitresTypesEtapesTypes('pre-97209-01')).toMatchInlineSnapshot(`[]`)
  expect(getAdministrationTitresTypesEtapesTypes('dea-guyane-01')).toMatchInlineSnapshot(`
    [
      {
        "creationInterdit": true,
        "etapeTypeId": "abd",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "acg",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "and",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "ape",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "css",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "des",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "dex",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "dpu",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "mec",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "men",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "mfr",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "ipc",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "ppu",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "rcg",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "rpe",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "sas",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "scg",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "spe",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "spp",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "cxm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "abd",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "acg",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "and",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "apu",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "css",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "des",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "dex",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "dpu",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "mec",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "men",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "mfr",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "ipc",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "ppu",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "rcg",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "sas",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "scg",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
      {
        "creationInterdit": true,
        "etapeTypeId": "spp",
        "lectureInterdit": false,
        "modificationInterdit": true,
        "titreTypeId": "prm",
      },
    ]
  `)
})
