import { ITitre } from '../../types'

import { titresGet } from '../../database/queries/titres'
import { userSuper } from '../../database/user-super'

import { titreSlugAndRelationsUpdate } from '../utils/titre-slug-and-relations-update'

// met à jour les slugs de titre
const titreSlugsUpdate = async (titre: ITitre) => {
  const titreOldSlug = titre.slug

  try {
    const { slug, hasChanged } = await titreSlugAndRelationsUpdate(titre)

    if (!hasChanged) return null

    console.info('titre : slug (mise à jour) ->', slug)

    return { [slug]: titreOldSlug }
  } catch (e) {
    console.error(`erreur: titreSlugsUpdate ${titreOldSlug}`, e)

    return null
  }
}

export const titresSlugsUpdate = async (titresIds?: string[]): Promise<Record<string, string>> => {
  console.info()
  console.info('slugs de titres, démarches, étapes et activités')

  const titres = await titresGet(
    { ids: titresIds },
    {
      fields: {
        demarches: {
          etapes: {
            id: {},
          },
        },
        activites: { id: {} },
      },
    },
    userSuper
  )

  const titresUpdatedIndex: Record<string, string> = {}

  for (const titre of titres) {
    const titreUpdatedIndex = await titreSlugsUpdate(titre)

    if (titreUpdatedIndex) {
      Object.assign(titresUpdatedIndex, titreUpdatedIndex)
    }
  }

  return titresUpdatedIndex
}
