import { restCall } from '../../../../tests/_utils/index'
import { dbManager } from '../../../../tests/db-manager'
import { expect, test, afterAll, beforeAll, vi } from 'vitest'
import type { Pool } from 'pg'
import { caminoAnneeValidator } from 'camino-common/src/date'

console.info = vi.fn()
console.error = vi.fn()
let dbPool: Pool

beforeAll(async () => {
  const { pool } = await dbManager.populateDb()
  dbPool = pool
})

afterAll(async () => {
  await dbManager.closeKnex()
})

test('peut récupérer les statistiques des granulats marins', async () => {
  const tested = await restCall(dbPool, '/rest/statistiques/granulatsMarins/:annee', { annee: caminoAnneeValidator.parse('2023') }, undefined)

  expect(tested.statusCode).toBe(200)
  expect(tested.body).toMatchSnapshot()
})
