/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.keycloak.providers.common;

import fr.insee.keycloak.providers.common.EidasLevel;
import java.util.Collections;
import java.util.List;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;

public abstract class AbstractBaseProviderConfig
extends OIDCIdentityProviderConfig {
    private static final String IS_CONFIG_CREATED_PROPERTY = "isCreated";

    protected AbstractBaseProviderConfig(IdentityProviderModel identityProviderModel) {
        super(identityProviderModel);
        this.initialize();
    }

    protected AbstractBaseProviderConfig() {
        this.initialize();
    }

    protected abstract String getEnvironmentProperty(String var1);

    protected void initialize() {
        this.configureUrlsFromEnvironment();
        this.setValidateSignature(true);
        this.setBackchannelSupported(false);
    }

    protected void configureUrlsFromEnvironment() {
        this.setAuthorizationUrl(this.getEnvironmentProperty("authorization.url"));
        this.setTokenUrl(this.getEnvironmentProperty("token.url"));
        this.setUserInfoUrl(this.getEnvironmentProperty("userinfo.url"));
        this.setLogoutUrl(this.getEnvironmentProperty("logout.url"));
        this.setIssuer(this.getEnvironmentProperty("issuer.url"));
        String useJwks = this.getEnvironmentProperty("use.jwks.url");
        if (useJwks != null) {
            this.setJwksUrl(this.getEnvironmentProperty("jwks.url"));
            this.setUseJwksUrl(Boolean.parseBoolean(useJwks));
        }
    }

    protected EidasLevel getDefaultEidasLevel() {
        return EidasLevel.EIDAS1;
    }

    protected List<IdentityProviderMapperModel> getDefaultMappers() {
        return Collections.emptyList();
    }

    public boolean isIgnoreAbsentStateParameterLogout() {
        return Boolean.parseBoolean((String)this.getConfig().get("ignoreAbsentStateParameterLogout"));
    }

    public void validate(RealmModel realm) {
        super.validate(realm);
        if (!this.isCreated()) {
            this.getDefaultMappers().forEach(arg_0 -> ((RealmModel)realm).addIdentityProviderMapper(arg_0));
            this.getConfig().put(IS_CONFIG_CREATED_PROPERTY, "true");
        }
    }

    public EidasLevel getEidasLevel() {
        return EidasLevel.getOrDefault((String)this.getConfig().get("eidas_values"), this.getDefaultEidasLevel());
    }

    private boolean isCreated() {
        return Boolean.parseBoolean((String)this.getConfig().get(IS_CONFIG_CREATED_PROPERTY));
    }
}

