/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.jboss.logging.Logger;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.services.Urls;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.account.AccountFormService;

public class AccountUrls
extends Urls {
    private static final Logger log = Logger.getLogger(AccountUrls.class);

    private static UriBuilder realmLogout(URI baseUri) {
        return AccountUrls.tokenBase(baseUri).path(OIDCLoginProtocolService.class, "logout");
    }

    public static UriBuilder accountBase(URI baseUri) {
        return AccountUrls.realmBase((URI)baseUri).path(RealmsResource.class, "getAccountService");
    }

    private static UriBuilder tokenBase(URI baseUri) {
        return AccountUrls.realmBase((URI)baseUri).path("{realm}/protocol/openid-connect");
    }

    public static URI accountApplicationsPage(URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "applicationsPage").build(new Object[]{realmName});
    }

    public static URI accountPage(URI baseUri, String realmName) {
        return AccountUrls.accountPageBuilder(baseUri).build(new Object[]{realmName});
    }

    public static UriBuilder accountPageBuilder(URI baseUri) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "accountPage");
    }

    public static URI accountPasswordPage(URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "passwordPage").build(new Object[]{realmName});
    }

    public static URI accountFederatedIdentityPage(URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "federatedIdentityPage").build(new Object[]{realmName});
    }

    public static URI accountFederatedIdentityUpdate(URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "processFederatedIdentityUpdate").build(new Object[]{realmName});
    }

    public static URI accountTotpPage(URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "totpPage").build(new Object[]{realmName});
    }

    public static URI accountLogPage(URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "logPage").build(new Object[]{realmName});
    }

    public static URI accountSessionsPage(URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "sessionsPage").build(new Object[]{realmName});
    }

    public static URI accountLogout(URI baseUri, URI redirectUri, String realmName, String idTokenHint) {
        return AccountUrls.realmLogout(baseUri).queryParam("post_logout_redirect_uri", new Object[]{redirectUri}).queryParam("id_token_hint", new Object[]{idTokenHint}).build(new Object[]{realmName});
    }

    public static URI accountResourcesPage(URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "resourcesPage").build(new Object[]{realmName});
    }

    public static URI accountResourceDetailPage(String resourceId, URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "resourceDetailPage").build(new Object[]{realmName, resourceId});
    }

    public static URI accountResourceGrant(String resourceId, URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "grantPermission").build(new Object[]{realmName, resourceId});
    }

    public static URI accountResourceShare(String resourceId, URI baseUri, String realmName) {
        return AccountUrls.accountBase(baseUri).path(AccountFormService.class, "shareResource").build(new Object[]{realmName, resourceId});
    }

    public static URI loginActionUpdatePassword(URI baseUri, String realmName) {
        return AccountUrls.loginActionsBase((URI)baseUri).path(LoginActionsService.class, "updatePassword").build(new Object[]{realmName});
    }

    public static URI loginActionUpdateTotp(URI baseUri, String realmName) {
        return AccountUrls.loginActionsBase((URI)baseUri).path(LoginActionsService.class, "updateTotp").build(new Object[]{realmName});
    }

    public static URI loginActionEmailVerification(URI baseUri, String realmName) {
        return AccountUrls.loginActionsBase((URI)baseUri).path(LoginActionsService.class, "emailVerification").build(new Object[]{realmName});
    }

    public static String localeCookiePath(URI baseUri, String realmName) {
        return AccountUrls.realmBase((URI)baseUri).path(realmName).build(new Object[0]).getRawPath();
    }
}

