/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.io.IOException;
import java.net.URI;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.services.AccountUrls;
import org.keycloak.theme.Theme;

public class UrlBean {
    private static final Logger logger = Logger.getLogger(UrlBean.class);
    private String realm;
    private Theme theme;
    private URI baseURI;
    private URI baseQueryURI;
    private URI currentURI;
    private String idTokenHint;

    public UrlBean(RealmModel realm, Theme theme, URI baseURI, URI baseQueryURI, URI currentURI, String idTokenHint) {
        this.realm = realm.getName();
        this.theme = theme;
        this.baseURI = baseURI;
        this.baseQueryURI = baseQueryURI;
        this.currentURI = currentURI;
        this.idTokenHint = idTokenHint;
    }

    public String getApplicationsUrl() {
        return AccountUrls.accountApplicationsPage(this.baseQueryURI, this.realm).toString();
    }

    public String getAccountUrl() {
        return AccountUrls.accountPage(this.baseQueryURI, this.realm).toString();
    }

    public String getPasswordUrl() {
        return AccountUrls.accountPasswordPage(this.baseQueryURI, this.realm).toString();
    }

    public String getSocialUrl() {
        return AccountUrls.accountFederatedIdentityPage(this.baseQueryURI, this.realm).toString();
    }

    public String getTotpUrl() {
        return AccountUrls.accountTotpPage(this.baseQueryURI, this.realm).toString();
    }

    public String getLogUrl() {
        return AccountUrls.accountLogPage(this.baseQueryURI, this.realm).toString();
    }

    public String getSessionsUrl() {
        return AccountUrls.accountSessionsPage(this.baseQueryURI, this.realm).toString();
    }

    public String getLogoutUrl() {
        return AccountUrls.accountLogout(this.baseQueryURI, this.currentURI, this.realm, this.idTokenHint).toString();
    }

    public String getResourceUrl() {
        return AccountUrls.accountResourcesPage(this.baseQueryURI, this.realm).toString();
    }

    public String getResourceDetailUrl(String id) {
        return AccountUrls.accountResourceDetailPage(id, this.baseQueryURI, this.realm).toString();
    }

    public String getResourceGrant(String id) {
        return AccountUrls.accountResourceGrant(id, this.baseQueryURI, this.realm).toString();
    }

    public String getResourceShare(String id) {
        return AccountUrls.accountResourceShare(id, this.baseQueryURI, this.realm).toString();
    }

    public String getResourcesPath() {
        URI uri = AccountUrls.themeRoot((URI)this.baseURI);
        return uri.getPath() + "/" + this.theme.getType().toString().toLowerCase() + "/" + this.theme.getName();
    }

    public String getResourcesCommonPath() {
        URI uri = AccountUrls.themeRoot((URI)this.baseURI);
        String commonPath = "";
        try {
            commonPath = this.theme.getProperties().getProperty("import");
        }
        catch (IOException ex) {
            logger.warn((Object)"Failed to load properties", (Throwable)ex);
        }
        if (commonPath == null || commonPath.isEmpty()) {
            commonPath = "/common/keycloak";
        }
        return uri.getPath() + "/" + commonPath;
    }
}

