/*
 * Decompiled with CFR 0.152.
 */
package com.github.leroyguillaume.keycloak.bcrypt;

import at.favre.lib.crypto.bcrypt.BCrypt;
import org.keycloak.credential.hash.PasswordHashProvider;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.credential.PasswordCredentialModel;

public class BCryptPasswordHashProvider
implements PasswordHashProvider {
    private final int defaultIterations;
    private final String providerId;

    public BCryptPasswordHashProvider(String providerId, int defaultIterations) {
        this.providerId = providerId;
        this.defaultIterations = defaultIterations;
    }

    public boolean policyCheck(PasswordPolicy policy, PasswordCredentialModel credential) {
        int policyHashIterations = policy.getHashIterations() == -1 ? this.defaultIterations : policy.getHashIterations();
        return credential.getPasswordCredentialData().getHashIterations() == policyHashIterations && this.providerId.equals(credential.getPasswordCredentialData().getAlgorithm());
    }

    public PasswordCredentialModel encodedCredential(String rawPassword, int iterations) {
        String encodedPassword = this.encode(rawPassword, iterations);
        return PasswordCredentialModel.createFromValues((String)this.providerId, (byte[])new byte[0], (int)iterations, (String)encodedPassword);
    }

    public String encode(String rawPassword, int iterations) {
        int cost = iterations == -1 ? this.defaultIterations : iterations;
        return BCrypt.with(BCrypt.Version.VERSION_2A).hashToString(cost, rawPassword.toCharArray());
    }

    public void close() {
    }

    public boolean verify(String rawPassword, PasswordCredentialModel credential) {
        String hash = credential.getPasswordSecretData().getValue();
        BCrypt.Result verifier = BCrypt.verifyer(BCrypt.Version.VERSION_2A).verify(rawPassword.toCharArray(), hash.toCharArray());
        return verifier.verified;
    }
}

