import { PureAdministrationDashboard } from './pure-administration-dashboard'
import { Meta, StoryFn } from '@storybook/vue3'
import { CommonTitreAdministration } from 'camino-common/src/titres'
import { entreprises, statistiquesDGTMFake, titresDreal } from './testData'
import { testBlankUser } from 'camino-common/src/tests-utils'
import { ADMINISTRATION_IDS } from 'camino-common/src/static/administrations'
import { titreIdValidator, titreSlugValidator } from 'camino-common/src/validators/titres'
import { TITRES_TYPES_IDS } from 'camino-common/src/static/titresTypes'
import { TitresStatutIds } from 'camino-common/src/static/titresStatuts'
import { entrepriseIdValidator } from 'camino-common/src/entreprise'
import { toCaminoDate } from 'camino-common/src/date'
import { ETAPES_TYPES } from 'camino-common/src/static/etapesTypes'
const meta: Meta = {
  title: 'Components/Dashboard/Administration',
  // @ts-ignore @storybook/vue3 n'aime pas les composants tsx
  component: PureAdministrationDashboard,
}
export default meta

export const Ok: StoryFn = () => (
  <PureAdministrationDashboard
    user={{ ...testBlankUser, role: 'admin', administrationId: ADMINISTRATION_IDS.BRGM }}
    entreprises={entreprises}
    apiClient={{
      getAdministrationTitres: () => Promise.resolve(titresDreal),
      getDgtmStats: () =>
        Promise.resolve({
          depotEtInstructions: {},
          sdom: {},
          delais: {},
          avisAXM: {},
          producteursOr: {},
        }),
    }}
  />
)

export const OkWithoutBlockedTitres: StoryFn = () => (
  <PureAdministrationDashboard
    apiClient={{
      getAdministrationTitres: () => Promise.resolve(titresDreal.filter(t => !t.enAttenteDeAdministration)),
      getDgtmStats: () =>
        Promise.resolve({
          depotEtInstructions: {},
          sdom: {},
          delais: {},
          avisAXM: {},
          producteursOr: {},
        }),
    }}
    user={{ ...testBlankUser, role: 'admin', administrationId: ADMINISTRATION_IDS.BRGM }}
    entreprises={entreprises}
  />
)

export const DGTMNoSnapshot: StoryFn = () => (
  <PureAdministrationDashboard
    apiClient={{ getAdministrationTitres: () => Promise.resolve(titresDreal), getDgtmStats: () => Promise.resolve(statistiquesDGTMFake) }}
    user={{ ...testBlankUser, role: 'admin', administrationId: ADMINISTRATION_IDS['DGTM - GUYANE'] }}
    entreprises={entreprises}
  />
)

export const DGALNNeVoitPasLesARMetAXM: StoryFn = () => (
  <PureAdministrationDashboard
    apiClient={{
      getAdministrationTitres: () =>
        Promise.resolve([
          ...titresDreal,
          {
            id: titreIdValidator.parse('titre-arm'),
            slug: titreSlugValidator.parse('titre-arm-slug'),
            nom: 'AUTORISATION_DE_RECHERCHE_METAUX',
            type_id: TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX,
            titre_statut_id: TitresStatutIds.DemandeInitiale,
            references: [],
            titulaireIds: [entrepriseIdValidator.parse('Titulaire1')],
            enAttenteDeAdministration: false,
            prochainesEtapes: [],
            derniereEtape: { date: toCaminoDate('2022-01-01'), etapeTypeId: ETAPES_TYPES.demande },
          },
          {
            id: titreIdValidator.parse('titre-axm'),
            slug: titreSlugValidator.parse('titre-axm-slug'),
            nom: 'AUTORISATION_EXPLOITATION_METAUX',
            type_id: TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX,
            titre_statut_id: TitresStatutIds.DemandeInitiale,
            references: [],
            titulaireIds: [entrepriseIdValidator.parse('Titulaire1')],
            enAttenteDeAdministration: false,
            prochainesEtapes: [],
            derniereEtape: { date: toCaminoDate('2022-01-01'), etapeTypeId: ETAPES_TYPES.demande },
          },
        ]),
      getDgtmStats: () => Promise.resolve(statistiquesDGTMFake),
    }}
    user={{ ...testBlankUser, role: 'admin', administrationId: ADMINISTRATION_IDS['DGALN/DEB/EARM2'] }}
    entreprises={entreprises}
  />
)

export const Loading: StoryFn = () => (
  <PureAdministrationDashboard
    user={{ ...testBlankUser, role: 'admin', administrationId: ADMINISTRATION_IDS.BRGM }}
    entreprises={entreprises}
    apiClient={{
      getAdministrationTitres: () => new Promise<CommonTitreAdministration[]>(_resolve => {}),
      getDgtmStats: () =>
        Promise.resolve({
          depotEtInstructions: {},
          sdom: {},
          delais: {},
          avisAXM: {},
          producteursOr: {},
        }),
    }}
  />
)
export const WithError: StoryFn = () => (
  <PureAdministrationDashboard
    apiClient={{
      getAdministrationTitres: () => Promise.reject(new Error('because reasons')),
      getDgtmStats: () =>
        Promise.resolve({
          depotEtInstructions: {},
          sdom: {},
          delais: {},
          avisAXM: {},
          producteursOr: {},
        }),
    }}
    user={{ ...testBlankUser, role: 'admin', administrationId: ADMINISTRATION_IDS.BRGM }}
    entreprises={entreprises}
  />
)
