import { Meta, StoryFn } from '@storybook/vue3'
import { action } from '@storybook/addon-actions'
import { DsfrToggle } from './dsfr-toggle'

const meta: Meta = {
  title: 'Components/UI/Dsfr/Toggle',
  // @ts-ignore @storybook/vue3 n'aime pas les composants tsx
  component: DsfrToggle,
}
export default meta
const valueChangedAction = action('valueChanged')

export const DefaultTrue: StoryFn = () => <DsfrToggle id="toggle1" legendLabel="Légende" valueChanged={valueChangedAction} initialValue={true} />
export const DefaultFalse: StoryFn = () => <DsfrToggle id="toggle2" legendLabel="Légende" valueChanged={valueChangedAction} initialValue={false} />
export const WithHint: StoryFn = () => <DsfrToggle id="toggle3" legendLabel="Légende" legendHint="une URL" valueChanged={valueChangedAction} initialValue={true} />
