import { Meta, StoryFn } from '@storybook/vue3'
import { DsfrSelect } from './dsfr-select'
import { action } from '@storybook/addon-actions'

const meta: Meta = {
  title: 'Components/UI/Dsfr/Select',
  // @ts-ignore @storybook/vue3 n'aime pas les composants tsx
  component: DsfrSelect,
}
export default meta

const onvalueChangedAction = action('valueChanged')
const items = [
  { id: 'id1', label: 'premier label' },
  { id: 'id2', label: 'second label' },
] as const

export const Default: StoryFn = () => <DsfrSelect required={true} id="select" legend={{ main: 'label de cadix' }} items={items} initialValue={null} valueChanged={onvalueChangedAction} />
export const WithDescriptionAndPlaceholder: StoryFn = () => (
  <DsfrSelect
    required={true}
    id="select"
    legend={{ main: 'label de cadix', description: 'Description', placeholder: 'Placeholder custom' }}
    items={items}
    initialValue={null}
    valueChanged={onvalueChangedAction}
  />
)
export const AlreadySelectedItem: StoryFn = () => <DsfrSelect required={true} id="select" legend={{ main: 'label de cadix' }} items={items} initialValue={'id1'} valueChanged={onvalueChangedAction} />

export const Disabled: StoryFn = () => (
  <DsfrSelect required={true} id="select" disabled={true} legend={{ main: 'label de cadix' }} items={items} initialValue={'id1'} valueChanged={onvalueChangedAction} />
)
export const Required: StoryFn = () => <DsfrSelect id="select" required={true} legend={{ main: 'label de cadix' }} items={items} initialValue={'id1'} valueChanged={onvalueChangedAction} />

export const ElementDisabled: StoryFn = () => (
  <DsfrSelect
    id="select"
    required={true}
    legend={{ main: 'label de cadix' }}
    items={[
      { id: 'id1', label: 'premier label' },
      { id: 'id2', label: 'second label' },
      { id: 'id3', label: 'troisième label désactivé', disabled: true },
    ]}
    initialValue={'id1'}
    valueChanged={onvalueChangedAction}
  />
)

export const Optional: StoryFn = () => <DsfrSelect id="select" required={false} legend={{ main: 'label de cadix' }} items={items} initialValue={'id1'} valueChanged={onvalueChangedAction} />
