import { test, vi, expect, describe, afterEach } from 'vitest'
import { mailjetSendForTestsOnly } from './emails'

import { mailJetSendMail } from './index'
const mailJetSendMailMock = vi.mocked(mailJetSendMail, true)

vi.mock('./index', () => ({
  __esModule: true,
  mailjetAddContactsToGuyaneList: vi.fn().mockImplementation(a => a),
  mailJetSendMail: vi.fn().mockImplementation(a => a),
}))

describe('mailjetSend', () => {
  afterEach(() => {
    vi.restoreAllMocks()
  })
  test('group by', async () => {
    await mailjetSendForTestsOnly(
      [...Array(100).keys()].map(i => `toto${i}@example.org`),
      { Subject: 'Subject', TextPart: 'This is a message' }
    )
    expect(mailJetSendMailMock).toHaveBeenCalledTimes(3)
    expect(mailJetSendMailMock.mock.calls).toMatchSnapshot()
  })
  test('no group by', async () => {
    await mailjetSendForTestsOnly(['toto@example.org'], { Subject: 'Subject', TextPart: 'This is a message' })
    expect(mailJetSendMailMock).toHaveBeenCalledOnce()
    expect(mailJetSendMailMock.mock.calls).toMatchSnapshot()
  })
})
