import '../init'
import pg from 'pg'
import { config } from '../config'

import { Effect } from 'effect'
import { fillDocumentsNonRenseigne } from '../business/fill-documents-non-renseigne'

const pool = new pg.Pool({
  host: config().PGHOST,
  user: config().PGUSER,
  password: config().PGPASSWORD,
  database: config().PGDATABASE,
})

Effect.runPromiseExit(fillDocumentsNonRenseigne(pool))
  .then(() => process.exit(0))
  .catch(reason => {
    console.error(reason)
    process.exit(1)
  })
