import { QGISTokenRest, UtilisateurToEdit, UtilisateursSearchParamsInput, UtilisateursTable } from 'camino-common/src/utilisateur'

import { newGetWithJson, newPostWithJson } from '../../api/client-rest'
import { UserNotNull, UtilisateurId } from 'camino-common/src/roles'
import { CaminoError } from 'camino-common/src/zod-tools'

export interface UtilisateurApiClient {
  getUtilisateur: (userId: UtilisateurId) => Promise<CaminoError<string> | UserNotNull>
  removeUtilisateur: (userId: UtilisateurId) => Promise<{ id: UtilisateurId } | CaminoError<string>>
  updateUtilisateur: (user: UtilisateurToEdit) => Promise<{ id: UtilisateurId } | CaminoError<string>>
  getQGISToken: () => Promise<CaminoError<string> | QGISTokenRest>
  getUtilisateurs: (params: UtilisateursSearchParamsInput) => Promise<CaminoError<string> | UtilisateursTable>
}

export const utilisateurApiClient: UtilisateurApiClient = {
  getUtilisateurs: async (params: UtilisateursSearchParamsInput) => {
    return newGetWithJson('/rest/utilisateurs', {}, params)
  },
  getUtilisateur: async (userId: UtilisateurId) => {
    return newGetWithJson('/rest/utilisateurs/:id', { id: userId })
  },
  removeUtilisateur: async (userId: UtilisateurId) => newGetWithJson('/rest/utilisateurs/:id/delete', { id: userId }),
  updateUtilisateur: async (utilisateur: UtilisateurToEdit) => newPostWithJson('/rest/utilisateurs/:id/permission', { id: utilisateur.id }, utilisateur),
  getQGISToken: async () => newPostWithJson('/rest/utilisateur/generateQgisToken', {}, {}),
}
