import { FunctionalComponent } from 'vue'
import { FunctionalPopup } from '../_ui/functional-popup'
import { Alert } from '@/components/_ui/alert'
import { UtilisateurApiClient } from './utilisateur-api-client'
import { UtilisateurId } from 'camino-common/src/roles'
interface Props {
  utilisateur: { id: UtilisateurId; nom: string; prenom: string }
  close: () => void
  apiClient: Pick<UtilisateurApiClient, 'removeUtilisateur'>
}

export const RemovePopup: FunctionalComponent<Props> = props => {
  const content = () => (
    <Alert
      type="warning"
      title="Attention : cette opération est définitive et ne peut pas être annulée."
      description={
        <>
          Souhaitez vous supprimer le compte de{' '}
          <span class="fr-text--bold">
            {props.utilisateur.prenom} {props.utilisateur.nom}
          </span>{' '}
          ?
        </>
      }
    />
  )

  return (
    <FunctionalPopup
      title={`Suppression du compte utilisateur`}
      content={content}
      close={props.close}
      validate={{ action: () => props.apiClient.removeUtilisateur(props.utilisateur.id), text: 'Supprimer' }}
      canValidate={true}
    />
  )
}
