import { action } from '@storybook/addon-actions'
import { Meta, StoryFn } from '@storybook/vue3'
import { RemovePopup } from './remove-popup'
import { utilisateurIdValidator } from 'camino-common/src/roles'

const meta: Meta = {
  title: 'Components/Utilisateur/RemovePopup',
  component: RemovePopup,
}
export default meta

const deleteUser = action('deleteUser')
const close = action('close')

export const Default: StoryFn = () => (
  <RemovePopup
    utilisateur={{ id: utilisateurIdValidator.parse('id'), nom: 'Nom', prenom: 'Prénom' }}
    apiClient={{
      removeUtilisateur: utilisateurId => {
        deleteUser(utilisateurId)

        return Promise.resolve({ id: utilisateurId })
      },
    }}
    close={close}
  />
)
