import { Meta, StoryFn } from '@storybook/vue3'
import { ApiClient } from '@/api/api-client'
import { action } from '@storybook/addon-actions'
import { CaminoRouteLocation } from '@/router/routes'
import { CaminoRouter } from '@/typings/vue-router'
import { PureMutations } from './mutations'
import { Mutation, mutationIdValidator } from 'camino-common/src/mutations'
import { utilisateurIdValidator } from 'camino-common/src/roles'

const meta: Meta = {
  title: 'Components/Mutations',
  // @ts-ignore @storybook/vue3 n'aime pas les composants tsx
  component: PureMutations,
}
export default meta

const elements: Mutation[] = [
  {
    id: mutationIdValidator.parse('a118f2bb-232f-4363-8689-42151c66bfbb'),
    datetime: '',
    method: 'post',
    path: '',
    utilisateur_nom: '',
    utilisateur_prenom: '',
    utilisateur_id: utilisateurIdValidator.parse('idUser'),
    camino_path: '',
    camino_variables: {},
  },

  {
    id: mutationIdValidator.parse('fce835ee-a857-4fc5-9721-c542060222b3'),
    datetime: '2025-04-07T19:00:35.824Z',
    method: 'post',
    path: '/rest/etapes/idEtape/depot',
    utilisateur_nom: 'Nom',
    utilisateur_prenom: 'Prénom',
    utilisateur_id: utilisateurIdValidator.parse('anotherUserId'),
    camino_path: '/rest/etapes/:etapeId/depot',
    camino_variables: { etapeId: 'idEtape' },
  },
]

const updateUrlQueryAction = action('updateUrlQuery')
const apiClient: Pick<ApiClient, 'titresRechercherByNom' | 'getTitresByIds' | 'getMutations'> = {
  titresRechercherByNom: () => {
    return Promise.resolve({ elements: [] })
  },
  getTitresByIds: () => {
    return Promise.resolve({ elements: [] })
  },
  getMutations: async () => {
    return elements
  },
}
const currentRoute: CaminoRouteLocation = { name: 'mutations', params: {}, query: {} }
const updateUrlQuery: Pick<CaminoRouter, 'push'> = {
  push: value => {
    updateUrlQueryAction(value)
    return Promise.resolve()
  },
}
export const Loading: StoryFn = () => <PureMutations currentRoute={currentRoute} updateUrlQuery={updateUrlQuery} apiClient={{ ...apiClient, getMutations: () => new Promise(() => ({})) }} />
export const WithError: StoryFn = () => (
  <PureMutations currentRoute={currentRoute} updateUrlQuery={updateUrlQuery} apiClient={{ ...apiClient, getMutations: () => Promise.resolve({ message: 'une erreur' }) }} />
)
export const Default: StoryFn = () => <PureMutations currentRoute={currentRoute} updateUrlQuery={updateUrlQuery} apiClient={apiClient} />
