import { Meta, StoryFn } from '@storybook/vue3'
import { ApiClient } from '@/api/api-client'
import { GetMutation, mutationIdValidator } from 'camino-common/src/mutations'
import { utilisateurIdValidator } from 'camino-common/src/roles'
import { PureMutation } from './mutation'

const meta: Meta = {
  title: 'Components/Mutation',
  // @ts-ignore @storybook/vue3 n'aime pas les composants tsx
  component: PureMutation,
}
export default meta

const mutationId = mutationIdValidator.parse('fce835ee-a857-4fc5-9721-c542060222b3')
const element: GetMutation = {
  id: mutationId,
  datetime: '2025-04-07T19:00:35.824Z',
  method: 'post',
  path: '/rest/etapes/idEtape/depot',
  utilisateur_nom: 'Nom',
  utilisateur_prenom: 'Prénom',
  utilisateur_id: utilisateurIdValidator.parse('anotherUserId'),
  camino_path: '/rest/etapes/:etapeId/depot',
  camino_variables: { etapeId: 'idEtape' },
  body: JSON.stringify({ test: 12 }),
}

const apiClient: Pick<ApiClient, 'getMutation'> = {
  getMutation: async () => {
    return element
  },
}

export const Loading: StoryFn = () => <PureMutation mutationId={mutationId} apiClient={{ ...apiClient, getMutation: () => new Promise(() => ({})) }} />
export const WithError: StoryFn = () => <PureMutation mutationId={mutationId} apiClient={{ ...apiClient, getMutation: () => Promise.resolve({ message: 'une erreur' }) }} />
export const Default: StoryFn = () => <PureMutation mutationId={mutationId} apiClient={apiClient} />
