import { SectionsEdit } from './sections-edit'
import { Meta, StoryFn } from '@storybook/vue3'
import { action } from '@storybook/addon-actions'
import { firstEtapeDateValidator, toCaminoDate } from 'camino-common/src/date'
import { MachineInfo } from 'camino-common/src/machines'
import { demarcheIdValidator } from 'camino-common/src/demarche'

const meta: Meta = {
  title: 'Components/Etape/SectionsEdit',
  // @ts-ignore
  component: SectionsEdit,
}
export default meta

const completeUpdate = action('completeUpdate')

const demarcheId = demarcheIdValidator.parse('demarcheId')
export const SansHeritage: StoryFn = () => (
  <SectionsEdit
    completeUpdate={completeUpdate}
    machineInfo={MachineInfo.withDate('arm', 'oct', demarcheId, firstEtapeDateValidator.parse('2024-01-01'))}
    etape={{
      typeId: 'mfr',
      contenu: { arm: { mecanise: { value: true, heritee: false, etapeHeritee: null }, franchissements: { value: null, heritee: false, etapeHeritee: null } } },
      date: toCaminoDate('2024-01-01'),
    }}
  />
)

export const AvecHeritageActif: StoryFn = () => (
  <SectionsEdit
    completeUpdate={completeUpdate}
    machineInfo={MachineInfo.withDate('arm', 'oct', demarcheId, firstEtapeDateValidator.parse('2024-01-01'))}
    etape={{
      date: toCaminoDate('2024-01-01'),
      typeId: 'mod',
      contenu: {
        arm: {
          mecanise: { value: true, heritee: true, etapeHeritee: { etapeTypeId: 'mfr', date: toCaminoDate('2024-01-01'), value: true } },
          franchissements: { value: 2, heritee: true, etapeHeritee: { etapeTypeId: 'mfr', date: toCaminoDate('2024-01-01'), value: 2 } },
        },
      },
    }}
  />
)

export const AvecHeritage: StoryFn = () => (
  <SectionsEdit
    completeUpdate={completeUpdate}
    machineInfo={MachineInfo.withDate('arm', 'oct', demarcheId, firstEtapeDateValidator.parse('2024-01-01'))}
    etape={{
      date: toCaminoDate('2024-01-01'),
      typeId: 'mod',
      contenu: {
        arm: {
          mecanise: { value: false, heritee: false, etapeHeritee: { etapeTypeId: 'mfr', date: toCaminoDate('2024-01-01'), value: true } },
          franchissements: { value: null, heritee: false, etapeHeritee: { etapeTypeId: 'mfr', date: toCaminoDate('2024-01-01'), value: 2 } },
        },
      },
    }}
  />
)

export const DecisionJorf: StoryFn = () => (
  <SectionsEdit
    completeUpdate={completeUpdate}
    machineInfo={MachineInfo.withDate('pcc', 'pro', demarcheId, firstEtapeDateValidator.parse('2000-05-16'))}
    etape={{
      date: toCaminoDate('2000-05-16'),
      typeId: 'dpu',
      contenu: {
        publication: {
          nor: {
            value: null,
            heritee: true,
            etapeHeritee: {
              etapeTypeId: 'dex',
              date: toCaminoDate('2000-05-16'),
              value: null,
            },
          },
          jorf: {
            value: null,
            heritee: false,
            etapeHeritee: null,
          },
        },
      },
    }}
  />
)
