import { Meta, StoryFn } from '@storybook/vue3'
import { EtapeAvisEdit } from './etape-avis-edit'
import { EtapeAvis, etapeAvisIdValidator, etapeIdValidator } from 'camino-common/src/etape'
import { ApiClient } from '../../api/api-client'
import { action } from '@storybook/addon-actions'
import { tempDocumentNameValidator } from 'camino-common/src/document'
import { caminoDateValidator, firstEtapeDateValidator } from 'camino-common/src/date'
import { AvisVisibilityIds } from 'camino-common/src/static/avisTypes'
import { testBlankUser } from 'camino-common/src/tests-utils'
import { communeIdValidator } from 'camino-common/src/static/communes'
import { demarcheIdValidator } from 'camino-common/src/demarche'
import { MachineInfo } from 'camino-common/src/machines'

const meta: Meta = {
  title: 'Components/Etape/EtapeAvisEdit',
  // @ts-ignore
  component: EtapeAvisEdit,
  decorators: [(): { template: string } => ({ template: '<div class="dsfr"><story/></div>' })],
}
export default meta

const avis: EtapeAvis[] = [
  {
    id: etapeAvisIdValidator.parse('id'),
    avis_type_id: 'confirmationAccordProprietaireDuSol',
    description: 'Une description',
    date: caminoDateValidator.parse('2023-02-01'),
    avis_statut_id: 'Favorable',
    has_file: false,
    avis_visibility_id: AvisVisibilityIds.Administrations,
  },
  {
    id: etapeAvisIdValidator.parse('id-car'),
    avis_type_id: 'autreAvis',
    description: 'Une description',
    date: caminoDateValidator.parse('2023-02-01'),
    avis_statut_id: 'Non renseigné',
    has_file: false,
    avis_visibility_id: AvisVisibilityIds.Public,
  },
]

const uploadTempDocumentAction = action('uploadTempDocument')
const getEtapeAvisByEtapeIdAction = action('getEtapeAvisByEtapeId')

const apiClient: Pick<ApiClient, 'uploadTempDocument' | 'getEtapeAvisByEtapeId'> = {
  getEtapeAvisByEtapeId: etapeId => {
    getEtapeAvisByEtapeIdAction(etapeId)

    return Promise.resolve(avis)
  },
  uploadTempDocument: document => {
    uploadTempDocumentAction(document)

    return Promise.resolve(tempDocumentNameValidator.parse(new Date().toISOString()))
  },
}

const completeUpdateAction = action('completeUpdate')
const demarcheId = demarcheIdValidator.parse('demarcheId')
const firstEtapeDate = firstEtapeDateValidator.parse('2022-01-01')
export const Empty: StoryFn = () => (
  <EtapeAvisEdit
    apiClient={{ ...apiClient, getEtapeAvisByEtapeId: () => Promise.resolve([]) }}
    etapeId={etapeIdValidator.parse('etapeId')}
    communeIds={[]}
    tde={{ machineInfo: MachineInfo.withDate('arm', 'oct', demarcheId, firstEtapeDate), etapeTypeId: 'mfr' }}
    onChange={completeUpdateAction}
    user={{ ...testBlankUser, role: 'super' }}
    contenu={{}}
  />
)
export const Rempli: StoryFn = () => (
  <EtapeAvisEdit
    apiClient={apiClient}
    etapeId={etapeIdValidator.parse('etapeId')}
    communeIds={[]}
    tde={{ machineInfo: MachineInfo.withDate('axm', 'oct', demarcheId, firstEtapeDate), etapeTypeId: 'asc' }}
    onChange={completeUpdateAction}
    user={{ ...testBlankUser, role: 'super' }}
    contenu={{}}
  />
)
export const DemandeARMProcedureSpecifique: StoryFn = () => (
  <EtapeAvisEdit
    apiClient={apiClient}
    etapeId={etapeIdValidator.parse('etapeId')}
    communeIds={[]}
    tde={{ machineInfo: MachineInfo.withDate('arm', 'oct', demarcheId, firstEtapeDateValidator.parse('2025-01-01')), etapeTypeId: 'mfr' }}
    onChange={completeUpdateAction}
    user={{ ...testBlankUser, role: 'super' }}
    contenu={{ arm: { mecanise: { value: true, heritee: false, etapeHeritee: null } } }}
  />
)
export const AvisEnGuyane: StoryFn = () => (
  <EtapeAvisEdit
    apiClient={{
      ...apiClient,
      getEtapeAvisByEtapeId: async () => {
        return Promise.resolve([
          ...avis,
          {
            id: etapeAvisIdValidator.parse('id-guyane'),
            avis_type_id: 'avisDirectionAlimentationAgricultureForet',
            description: 'Visible que en Guyane',
            date: caminoDateValidator.parse('2023-02-01'),
            avis_statut_id: 'Non renseigné',
            has_file: false,
            avis_visibility_id: AvisVisibilityIds.Public,
          },
        ])
      },
    }}
    etapeId={etapeIdValidator.parse('etapeId')}
    communeIds={[communeIdValidator.parse('97302')]}
    tde={{ machineInfo: MachineInfo.withDate('arm', 'oct', demarcheId, firstEtapeDate), etapeTypeId: 'asc' }}
    onChange={completeUpdateAction}
    user={{ ...testBlankUser, role: 'super' }}
    contenu={{}}
  />
)
