import { Meta, StoryFn } from '@storybook/vue3'
import { testBlankUser } from 'camino-common/src/tests-utils'
import { titreSlugValidator } from 'camino-common/src/validators/titres'
import { PureSuperDashboard } from './pure-super-dashboard'
import { SuperTitre } from 'camino-common/src/titres'
import { demarcheSlugValidator } from 'camino-common/src/demarche'
import { caminoDateValidator, toCaminoAnnee } from 'camino-common/src/date'
import { etapeSlugValidator } from 'camino-common/src/etape'
import { activiteIdValidator, ActiviteSuper } from 'camino-common/src/activite'
import { CaminoRouteLocation } from '@/router/routes'
import { CaminoRouter } from '@/typings/vue-router'
import { ACTIVITES_TYPES_IDS } from 'camino-common/src/static/activitesTypes'
import { ACTIVITES_STATUTS_IDS } from 'camino-common/src/static/activitesStatuts'
import { TITRES_TYPES_IDS } from 'camino-common/src/static/titresTypes'

const meta: Meta = {
  title: 'Components/Dashboard/Super',
  // @ts-ignore @storybook/vue3 n'aime pas les composants tsx
  component: PureSuperDashboard,
}
export default meta

const activites: ActiviteSuper[] = [
  {
    activite_statut_id: ACTIVITES_STATUTS_IDS.DEPOSE,
    annee: toCaminoAnnee(2025),
    id: activiteIdValidator.parse('id1'),
    periode_id: 1,
    titre_nom: 'Nom du titre',
    titre_type_id: TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX,
    type_id: ACTIVITES_TYPES_IDS["rapport trimestriel d'exploitation d'or en Guyane"],
  },
  {
    activite_statut_id: ACTIVITES_STATUTS_IDS.CLOTURE,
    annee: toCaminoAnnee(2024),
    id: activiteIdValidator.parse('id2'),
    periode_id: 3,
    titre_nom: 'Nom du titre 2',
    titre_type_id: TITRES_TYPES_IDS.PERMIS_D_EXPLOITATION_METAUX,
    type_id: ACTIVITES_TYPES_IDS["rapport d'intensité d'exploration"],
  },
]
const titres: SuperTitre[] = [
  {
    titre_nom: 'Aachen',
    titre_slug: titreSlugValidator.parse('m-cx-aachen-1810'),
    titre_type_id: 'cxm',
    titre_statut_id: 'ech',
    demarche_slug: demarcheSlugValidator.parse('m-cx-aachen-1810-oct01'),
    demarche_type_id: 'oct',
    etape_date: caminoDateValidator.parse('1810-01-01'),
    etape_slug: etapeSlugValidator.parse('m-cx-aachen-1810-oct01-mfr01'),
    etape_type_id: 'mfr',
    machine_id: 'AncienLogigrammeOctroiARM',
  },
  {
    titre_nom: 'Amadis 5',
    titre_slug: titreSlugValidator.parse('m-ax-amadis-5-2022'),
    titre_type_id: 'pxg',
    titre_statut_id: 'val',
    demarche_slug: demarcheSlugValidator.parse('m-ax-amadis-5-2022-oct01'),
    demarche_type_id: 'oct',
    etape_date: caminoDateValidator.parse('2022-01-01'),
    etape_slug: etapeSlugValidator.parse('m-ax-amadis-5-2022-oct01-mfr01'),
    etape_type_id: 'asc',
    machine_id: 'ProcedureSpecifique',
  },
]

const router: Pick<CaminoRouter, 'push'> = {
  push: _ => {
    return Promise.resolve()
  },
}

const routeBrouillon: CaminoRouteLocation = {
  name: 'dashboard',
  params: {},
  query: { vueId: 'brouillons' },
}

const routeActivite: CaminoRouteLocation = {
  name: 'dashboard',
  params: {},
  query: { vueId: 'activites' },
}

export const TableauVideBrouillon: StoryFn = () => (
  <PureSuperDashboard
    user={{ role: 'super', ...testBlankUser }}
    apiClient={{
      getTitresAvecEtapeEnBrouillon: () => Promise.resolve([]),
      getActivitesSuper: () => Promise.resolve([]),
    }}
    route={routeBrouillon}
    router={router}
  />
)
export const TableauVideActivites: StoryFn = () => (
  <PureSuperDashboard
    user={{ role: 'super', ...testBlankUser }}
    apiClient={{
      getTitresAvecEtapeEnBrouillon: () => Promise.resolve([]),
      getActivitesSuper: () => Promise.resolve([]),
    }}
    route={routeActivite}
    router={router}
  />
)

export const TableauPleinBrouillon: StoryFn = () => (
  <PureSuperDashboard
    user={{ role: 'super', ...testBlankUser }}
    apiClient={{
      getTitresAvecEtapeEnBrouillon: () => Promise.resolve(titres),
      getActivitesSuper: () => Promise.resolve(activites),
    }}
    route={routeBrouillon}
    router={router}
  />
)
export const TableauPleinActivites: StoryFn = () => (
  <PureSuperDashboard
    user={{ role: 'super', ...testBlankUser }}
    apiClient={{
      getTitresAvecEtapeEnBrouillon: () => Promise.resolve(titres),
      getActivitesSuper: () => Promise.resolve(activites),
    }}
    route={routeActivite}
    router={router}
  />
)
export const LoadingBrouillon: StoryFn = () => (
  <PureSuperDashboard
    user={{ role: 'super', ...testBlankUser }}
    apiClient={{
      getTitresAvecEtapeEnBrouillon: () => new Promise<SuperTitre[]>(_resolve => {}),
      getActivitesSuper: () => Promise.resolve([]),
    }}
    route={routeBrouillon}
    router={router}
  />
)
export const LoadingActivites: StoryFn = () => (
  <PureSuperDashboard
    user={{ role: 'super', ...testBlankUser }}
    apiClient={{
      getTitresAvecEtapeEnBrouillon: () => Promise.resolve([]),
      getActivitesSuper: () => new Promise<ActiviteSuper[]>(_resolve => {}),
    }}
    route={routeActivite}
    router={router}
  />
)

export const WithErrorBrouillon: StoryFn = () => (
  <PureSuperDashboard
    user={{ role: 'super', ...testBlankUser }}
    apiClient={{
      getTitresAvecEtapeEnBrouillon: () => Promise.resolve({ message: 'Une erreur' }),
      getActivitesSuper: () => Promise.resolve([]),
    }}
    route={routeBrouillon}
    router={router}
  />
)

export const WithErrorActivites: StoryFn = () => (
  <PureSuperDashboard
    user={{ role: 'super', ...testBlankUser }}
    apiClient={{
      getTitresAvecEtapeEnBrouillon: () => Promise.resolve([]),
      getActivitesSuper: () => Promise.resolve({ message: 'Une erreur' }),
    }}
    route={routeActivite}
    router={router}
  />
)
