import { defineAsyncComponent, defineComponent, inject, onMounted, ref } from 'vue'
import { useRouter } from 'vue-router'
import { dashboardApiClient } from './dashboard/dashboard-api-client'
import { AdminUserNotNull, EntrepriseUserNotNull, User, isAdministration, isEntrepriseOrBureauDEtude, isSuper } from 'camino-common/src/roles'
import { entreprisesKey, userKey } from '@/moi'
import { Entreprise } from 'camino-common/src/entreprise'
import { CaminoRouteLocation } from '@/router/routes'
import { CaminoRouter } from '@/typings/vue-router'

export const Dashboard = defineComponent({
  setup() {
    const router = useRouter()

    const user = inject(userKey)
    const entreprises = inject(entreprisesKey, ref([]))

    onMounted(async () => {
      if (!isEntrepriseOrBureauDEtude(user) && !isAdministration(user) && !isSuper(user)) {
        router.replace({ name: 'titres' })
      }
    })

    return () => <PureDashboard user={user} entreprises={entreprises.value} router={router} route={router.currentRoute.value} />
  },
})

type PureDashboardProps = { user: User; entreprises: Entreprise[]; route: CaminoRouteLocation; router: CaminoRouter }
const PureDashboard = defineComponent((props: PureDashboardProps) => {
  return () => (
    <>
      {isEntrepriseOrBureauDEtude(props.user) ? <PureEntrepriseDashboard user={props.user} entreprises={props.entreprises} /> : null}
      {isAdministration(props.user) ? <PureAdministrationDashboard user={props.user} entreprises={props.entreprises} /> : null}
      {isSuper(props.user) ? <PureSuperDashboard {...props} /> : null}
    </>
  )
})

const PureEntrepriseDashboard = defineComponent((props: Pick<PureDashboardProps, 'entreprises'> & { user: EntrepriseUserNotNull }) => {
  const PureEntrepriseDashboardComponent = defineAsyncComponent(async () => {
    const { PureEntrepriseDashboard } = await import('@/components/dashboard/pure-entreprise-dashboard')

    return PureEntrepriseDashboard
  })
  const entrepriseIds = props.user.entrepriseIds ?? []

  return () => <PureEntrepriseDashboardComponent apiClient={dashboardApiClient} user={props.user} entrepriseIds={entrepriseIds} allEntreprises={props.entreprises} />
})

const PureSuperDashboard = defineComponent((props: PureDashboardProps) => {
  const PureSuperDashboardComponent = defineAsyncComponent(async () => {
    const { PureSuperDashboard } = await import('@/components/dashboard/pure-super-dashboard')

    return PureSuperDashboard
  })

  return () => <PureSuperDashboardComponent apiClient={dashboardApiClient} user={props.user} route={props.route} router={props.router} />
})

const PureAdministrationDashboard = defineComponent((props: Pick<PureDashboardProps, 'entreprises'> & { user: AdminUserNotNull }) => {
  const PureAdministrationDashboardComponent = defineAsyncComponent(async () => {
    const { PureAdministrationDashboard } = await import('@/components/dashboard/pure-administration-dashboard')

    return PureAdministrationDashboard
  })

  return () => <PureAdministrationDashboardComponent apiClient={dashboardApiClient} user={props.user} entreprises={props.entreprises} />
})

// @ts-ignore waiting for https://github.com/vuejs/core/issues/7833
PureDashboard.props = ['user', 'entreprises', 'route', 'router']

// @ts-ignore waiting for https://github.com/vuejs/core/issues/7833
PureSuperDashboard.props = ['user', 'entreprises', 'route', 'router']

// @ts-ignore waiting for https://github.com/vuejs/core/issues/7833
PureAdministrationDashboard.props = ['user', 'entreprises', 'route', 'router']

// @ts-ignore waiting for https://github.com/vuejs/core/issues/7833
PureEntrepriseDashboard.props = ['user', 'entreprises', 'route', 'router']
