import { FunctionalPopup } from '../_ui/functional-popup'
import { ActiviteApiClient } from './activite-api-client'
import { Activite } from 'camino-common/src/activite'
import { Alert } from '../_ui/alert'
import { ActivitesTypes } from 'camino-common/src/static/activitesTypes'
import { defineComponent } from 'vue'
import { ActiviteStatut } from '../_common/activite-statut'
import { ACTIVITES_STATUTS_IDS } from 'camino-common/src/static/activitesStatuts'

interface Props {
  close: () => void
  apiClient: Pick<ActiviteApiClient, 'resetActiviteStatus'>
  activite: Pick<Activite, 'id' | 'titre' | 'type_id'>
}
export const ActiviteResetPopup = defineComponent<Props>(props => {
  const content = () => (
    <Alert
      type="warning"
      title="Attention : cette opération est définitive et ne peut pas être annulée."
      description={
        <>
          Ce <span class="fr-text--bold"> {ActivitesTypes[props.activite.type_id].nom}</span> du titre
          <span class="fr-text--bold"> {props.activite.titre.nom}</span> va passer de <ActiviteStatut activiteStatutId={ACTIVITES_STATUTS_IDS.DEPOSE} /> à{' '}
          <ActiviteStatut activiteStatutId={ACTIVITES_STATUTS_IDS.EN_CONSTRUCTION} />.<p>Les données seront conservées.</p>
        </>
      }
    />
  )

  return () => (
    <FunctionalPopup
      title="Réinitialisation"
      content={content}
      close={props.close}
      validate={{
        action: () => props.apiClient.resetActiviteStatus(props.activite.id),
        text: 'Réinitialiser',
      }}
      canValidate={true}
    />
  )
})
// @ts-ignore waiting for https://github.com/vuejs/core/issues/7833
ActiviteResetPopup.props = ['close', 'apiClient', 'activite']
