import { Meta, StoryFn } from '@storybook/vue3'
import { action } from '@storybook/addon-actions'
import { activiteIdValidator } from 'camino-common/src/activite'
import { ActiviteResetPopup } from './reset-popup'
import { ActiviteApiClient } from './activite-api-client'

const meta: Meta = {
  title: 'Components/Activite/ResetPopup',
  // @ts-ignore @storybook/vue3 n'aime pas les composants tsx
  component: ActiviteResetPopup,
}
export default meta

const close = action('close')
const resetActiviteAction = action('resetActiviteAction')

const apiClient: Pick<ActiviteApiClient, 'resetActiviteStatus'> = {
  resetActiviteStatus: (...params) => {
    resetActiviteAction(params)

    return Promise.resolve({ id: params[0] })
  },
}
export const Default: StoryFn = () => (
  <ActiviteResetPopup close={close} apiClient={apiClient} activite={{ id: activiteIdValidator.parse('activiteId'), type_id: 'gra', titre: { nom: 'Titre 1', slug: 'slug' } }} />
)
