import { FunctionalComponent } from 'vue'
import { Badge } from '../_ui/badge'
import { isDefautRole, UserNotNull } from 'camino-common/src/roles'
import { TitreVisibilite as TitreVisibiliteCommon } from 'camino-common/src/static/titresTypes'
import { isNotNullNorUndefined } from 'camino-common/src/typescript-tools'

type Props = {
  titre_visibilite: TitreVisibiliteCommon
  user: Pick<UserNotNull, 'role'> | null | undefined
}

export const TitreVisibilite: FunctionalComponent<Props> = (props: Props) => {
  if (isNotNullNorUndefined(props.user) && !isDefautRole(props.user.role)) {
    return (
      <Badge ariaLabel={props.titre_visibilite === 'Publique' ? 'Titre public' : 'Titre confidentiel'} badgeColor={props.titre_visibilite === 'Publique' ? 'green-bourgeon' : 'beige-gris-galet'} />
    )
  }
  return null
}
