import { FunctionalComponent } from 'vue'
import { Badge } from '../_ui/badge'
import { isDefautRole, UserNotNull } from 'camino-common/src/roles'
import { TitreVisibilite } from 'camino-common/src/static/titresTypes'
import { DemarcheVisibilite } from 'camino-common/src/static/demarchesTypes'
import { EtapesTypes, EtapeTypeId, EtapeVisibilite as EtapeVisibiliteCommon } from 'camino-common/src/static/etapesTypes'
import { isNotNullNorUndefined } from 'camino-common/src/typescript-tools'

type Props = {
  titre_visibilite: TitreVisibilite
  demarche_visibilite: DemarcheVisibilite
  etape_type_id: EtapeTypeId
  user: Pick<UserNotNull, 'role'> | null | undefined
}

export const EtapeVisibilite: FunctionalComponent<Props> = (props: Props) => {
  if (isNotNullNorUndefined(props.user) && !isDefautRole(props.user?.role)) {
    let visibilite: EtapeVisibiliteCommon = 'Confidentielle'
    const { public_lecture, entreprises_lecture } = EtapesTypes[props.etape_type_id]
    if (public_lecture && props.demarche_visibilite === 'Publique' && props.titre_visibilite === 'Publique') {
      visibilite = 'Publique'
    } else if (entreprises_lecture && props.demarche_visibilite === 'Publique' && props.titre_visibilite === 'Publique') {
      visibilite = 'Entreprise et administrations'
    }
    const label = visibilite === 'Publique' ? 'Étape publique' : visibilite === 'Confidentielle' ? 'Étape confidentielle' : "Visible par l'entreprise"

    return (
      <Badge
        label={label}
        ariaLabel={
          visibilite !== 'Publique' && public_lecture
            ? 'Cette étape deviendra publique quand la démarche et le titre seront publics'
            : visibilite === 'Entreprise et administrations'
              ? "Cette étape est visible par l'entreprise et les administrations"
              : label
        }
        badgeColor={visibilite === 'Publique' ? 'green-bourgeon' : 'beige-gris-galet'}
      />
    )
  }
  return null
}
