import { Meta, StoryFn } from '@storybook/vue3'
import { EtapeVisibilite } from './etape-visibilite'
import { TitreVisibilite as TitreVisibiliteCommon } from 'camino-common/src/static/titresTypes'
import { DemarcheVisibilite as DemarcheVisibiliteCommon } from 'camino-common/src/static/demarchesTypes'
import { ETAPES_TYPES, EtapesTypes, EtapeTypeId } from 'camino-common/src/static/etapesTypes'
import { getEntriesHardcore } from 'camino-common/src/typescript-tools'
import { Role } from 'camino-common/src/roles'
import { TitreVisibilite } from './titre-visibilite'
import { DemarcheVisibilite } from './demarche-visibilite'

const meta: Meta = {
  title: 'Components/Common/EtapeVisibilite',
  component: EtapeVisibilite,
}
export default meta

const etapeTypeIdsWithVisibility = [
  // Tout privé
  ETAPES_TYPES.demandeDautorisationDouvertureDeTravauxMiniers_AOTM_,
  // Tout public
  ETAPES_TYPES.consultationDuPublic,
  // Que entreprise
  ETAPES_TYPES.validationDuPaiementDesFraisDeDossierComplementaires,
] as const satisfies EtapeTypeId[]
const visibilite = {
  Confidentielle: {
    Confidentielle: etapeTypeIdsWithVisibility,
    Publique: etapeTypeIdsWithVisibility,
  },
  Publique: {
    Confidentielle: etapeTypeIdsWithVisibility,
    Publique: etapeTypeIdsWithVisibility,
  },
} as const satisfies Record<TitreVisibiliteCommon, Record<DemarcheVisibiliteCommon, EtapeTypeId[]>>

const roles = {
  super: visibilite,
  admin: visibilite,
  editeur: visibilite,
  lecteur: visibilite,
  entreprise: visibilite,
  "bureau d'études": visibilite,
  defaut: visibilite,
} as const satisfies Record<Role, typeof visibilite>
export const All: StoryFn = () => (
  <div style="height:100%;width:100%;background:white">
    <table>
      <tr>
        <th>Rôle de l'utilisateur</th>
        <th>Visibilité du titre</th>
        <th>Visibilité de la démarche</th>
        <th>Visibilité de l'étape</th>
        <th>Rendu</th>
      </tr>
      {getEntriesHardcore(roles).map(([role, roleVisibilite]) =>
        getEntriesHardcore(roleVisibilite).map(([titreVisibilite, demarches]) =>
          getEntriesHardcore(demarches).map(([demarcheVisibilite, etapes]) =>
            etapes.map(etape => (
              <tr>
                <td>{role}</td>
                <td>{titreVisibilite}</td>
                <td>{demarcheVisibilite}</td>
                <td>{EtapesTypes[etape].public_lecture ? 'Public' : EtapesTypes[etape].entreprises_lecture ? 'Entreprises' : 'Confidentielle'}</td>
                <td>
                  <div style={{ display: 'flex', gap: '1rem' }}>
                    <TitreVisibilite titre_visibilite={titreVisibilite} user={{ role: role }} />
                    <DemarcheVisibilite titre_visibilite={titreVisibilite} demarche_visibilite={demarcheVisibilite} user={{ role: role }} />
                    <EtapeVisibilite user={{ role: role }} demarche_visibilite={demarcheVisibilite} titre_visibilite={titreVisibilite} etape_type_id={etape} />
                  </div>
                </td>
              </tr>
            ))
          )
        )
      )}
    </table>
  </div>
)
