import { FunctionalComponent } from 'vue'
import { Badge } from '../_ui/badge'
import { isDefautRole, UserNotNull } from 'camino-common/src/roles'
import { TitreVisibilite } from 'camino-common/src/static/titresTypes'
import { DemarcheVisibilite as DemarcheVisibiliteCommon } from 'camino-common/src/static/demarchesTypes'
import { isNotNullNorUndefined } from 'camino-common/src/typescript-tools'

type Props = {
  titre_visibilite: TitreVisibilite
  demarche_visibilite: DemarcheVisibiliteCommon
  user: Pick<UserNotNull, 'role'> | null | undefined
}

export const DemarcheVisibilite: FunctionalComponent<Props> = (props: Props) => {
  if (isNotNullNorUndefined(props.user) && !isDefautRole(props.user.role)) {
    let visibilite: DemarcheVisibiliteCommon = 'Confidentielle'
    if (props.demarche_visibilite === 'Publique' && props.titre_visibilite === 'Publique') {
      visibilite = 'Publique'
    }
    const label = visibilite === 'Publique' ? 'Démarche publique' : 'Démarche confidentielle'

    return (
      <Badge
        label={label}
        ariaLabel={visibilite != 'Publique' && props.demarche_visibilite === 'Publique' ? 'Cette démarche deviendra publique quand le titre sera public' : label}
        badgeColor={visibilite === 'Publique' ? 'green-bourgeon' : 'beige-gris-galet'}
      />
    )
  }
  return null
}
