import { expect, test } from 'vitest'
import { getEntrepriseDocuments } from './entrepriseDocuments'
import { TITRES_TYPES_IDS } from '../titresTypes'
import { DEMARCHES_TYPES_IDS } from '../demarchesTypes'
import { ETAPES_TYPES } from '../etapesTypes'
import { MachineInfo } from '../../machines'
import { demarcheIdValidator } from '../../demarche'
import { firstEtapeDateValidator } from '../../date'

const demarcheId = demarcheIdValidator.parse('demarcheId')
const firstEtapeDate = firstEtapeDateValidator.parse('2020-01-01')
test('getEntrepriseDocuments pas de documents', () => {
  expect(
    getEntrepriseDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_DE_PROSPECTION_METAUX, DEMARCHES_TYPES_IDS.Amodiation, demarcheId, firstEtapeDate),
      ETAPES_TYPES.declarationDouvertureDeTravauxMiniers_DOTM_
    )
  ).toMatchInlineSnapshot('[]')
})

test('getEntrepriseDocuments', () => {
  expect(getEntrepriseDocuments(MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate), ETAPES_TYPES.demande))
    .toMatchInlineSnapshot(`
    [
      {
        "description": undefined,
        "id": "atf",
        "nom": "Attestation fiscale",
        "optionnel": false,
      },
      {
        "id": "sir",
        "nom": "Avis de situation au répertoire Sirene",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "cur",
        "nom": "Curriculum vitae",
        "optionnel": false,
      },
      {
        "description": undefined,
        "id": "idm",
        "nom": "Identification de matériel",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "jid",
        "nom": "Justificatif d'identité",
        "optionnel": false,
      },
      {
        "description": undefined,
        "id": "jct",
        "nom": "Justificatif des capacités techniques",
        "optionnel": false,
      },
      {
        "description": undefined,
        "id": "kbi",
        "nom": "Kbis",
        "optionnel": false,
      },
      {
        "description": undefined,
        "id": "jcf",
        "nom": "Justificatif des capacités financières",
        "optionnel": false,
      },
    ]
  `)

  expect(getEntrepriseDocuments(MachineInfo.withDate(TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_RADIOACTIF, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate), ETAPES_TYPES.demande))
    .toMatchInlineSnapshot(`
    [
      {
        "id": "atf",
        "nom": "Attestation fiscale",
        "optionnel": true,
      },
      {
        "id": "sir",
        "nom": "Avis de situation au répertoire Sirene",
        "optionnel": true,
      },
      {
        "id": "cur",
        "nom": "Curriculum vitae",
        "optionnel": true,
      },
      {
        "id": "idm",
        "nom": "Identification de matériel",
        "optionnel": true,
      },
      {
        "id": "jid",
        "nom": "Justificatif d'identité",
        "optionnel": true,
      },
      {
        "id": "jct",
        "nom": "Justificatif des capacités techniques",
        "optionnel": true,
      },
      {
        "id": "kbi",
        "nom": "Kbis",
        "optionnel": true,
      },
      {
        "id": "jcf",
        "nom": "Justificatif des capacités financières",
        "optionnel": true,
      },
    ]
  `)
})
