import { firstEtapeDateValidator } from '../../date'
import { demarcheIdValidator } from '../../demarche'
import { MachineInfo } from '../../machines'
import { DEMARCHES_TYPES_IDS } from '../demarchesTypes'
import { ETAPES_TYPES } from '../etapesTypes'
import { IS_ARM_MECANISE, IS_ARM_NON_MECANISE } from '../mecanise'
import { TITRES_TYPES_IDS } from '../titresTypes'
import { getDocuments, toDocuments } from './documents'
import { test, expect } from 'vitest'

test('toDocuments', () => {
  expect(toDocuments()).toHaveLength(197)
})

const firstEtapeDate = firstEtapeDateValidator.parse('2020-11-01')
const demarcheId = demarcheIdValidator.parse('id1Demarche')
test('getDocuments pas de surcharge mais pas de documents', () => {
  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_DE_PROSPECTION_METAUX, DEMARCHES_TYPES_IDS.Amodiation, demarcheId, firstEtapeDate),
      ETAPES_TYPES.publicationDansUnJournalLocalOuNational,
      [],
      IS_ARM_NON_MECANISE
    )
  ).toMatchInlineSnapshot(`
    [
      {
        "id": "aut",
        "nom": "Autre document",
        "optionnel": true,
      },
    ]
  `)
})

test('getDocuments pas de surcharge', () => {
  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_DE_PROSPECTION_METAUX, DEMARCHES_TYPES_IDS.Amodiation, demarcheId, firstEtapeDate),
      ETAPES_TYPES.declarationDouvertureDeTravauxMiniers_DOTM_,
      [],
      IS_ARM_NON_MECANISE
    )
  ).toMatchInlineSnapshot(`
    [
      {
        "id": "dcl",
        "nom": "Déclaration",
        "optionnel": true,
      },
      {
        "id": "aut",
        "nom": "Autre document",
        "optionnel": true,
      },
    ]
  `)
})

test('getDocuments surcharge', () => {
  expect(
    getDocuments(MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate), ETAPES_TYPES.demande, [], IS_ARM_NON_MECANISE)
  ).toMatchSnapshot()

  expect(
    getDocuments(MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate), ETAPES_TYPES.demande, [], IS_ARM_NON_MECANISE)
  ).not.toEqual(
    getDocuments(MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX, DEMARCHES_TYPES_IDS.Cession, demarcheId, firstEtapeDate), ETAPES_TYPES.demande, [], IS_ARM_NON_MECANISE)
  )
})

test("la lettre des saisines est obligatoire pour l'avis des services et commissions consultatives", () => {
  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate),
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      [],
      IS_ARM_NON_MECANISE
    )
  ).toMatchInlineSnapshot(`
    [
      {
        "id": "lcm",
        "nom": "Lettre de saisine des services civils et militaires",
        "optionnel": false,
      },
      {
        "id": "aut",
        "nom": "Autre document",
        "optionnel": true,
      },
    ]
  `)
})

test("le courrier de notification au préfet est obligatoire pour l'information du préfet et des collectivités", () => {
  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate),
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      [],
      IS_ARM_NON_MECANISE
    )
  ).toMatchInlineSnapshot(`
    [
      {
        "id": "cnp",
        "nom": "Courrier de notification au préfet",
        "optionnel": false,
      },
      {
        "id": "aut",
        "nom": "Autre document",
        "optionnel": true,
      },
    ]
  `)
})

test('getDocuments', () => {
  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheIdValidator.parse('demarcheId'), firstEtapeDateValidator.parse('2022-01-01')),
      ETAPES_TYPES.consultationDesAdministrationsCentrales,
      [],
      IS_ARM_NON_MECANISE
    )
  ).toMatchInlineSnapshot(`
    [
      {
        "id": "lac",
        "nom": "Lettre de saisine des services de l'administration centrale",
        "optionnel": false,
      },
      {
        "id": "aut",
        "nom": "Autre document",
        "optionnel": true,
      },
    ]
  `)

  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheIdValidator.parse('demarcheId'), firstEtapeDateValidator.parse('2022-01-01')),
      ETAPES_TYPES.demande,
      [],
      IS_ARM_NON_MECANISE
    )
  ).toMatchInlineSnapshot(`
    [
      {
        "id": "cam",
        "nom": "Contrat d'amodiation",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "car",
        "nom": "Documents cartographiques",
        "optionnel": false,
      },
      {
        "id": "cnt",
        "nom": "Contrat",
        "optionnel": true,
      },
      {
        "id": "cod",
        "nom": "Compléments au dossier de demande",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "dep",
        "nom": "Décision cas par cas",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "doe",
        "nom": "Dossier "Loi sur l'eau"",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "dom",
        "nom": "Dossier de demande",
        "optionnel": false,
      },
      {
        "id": "dos",
        "nom": "Dossier",
        "optionnel": true,
      },
      {
        "id": "fac",
        "nom": "Facture",
        "optionnel": true,
      },
      {
        "id": "fic",
        "nom": "Fiche de complétude",
        "optionnel": true,
      },
      {
        "id": "fip",
        "nom": "Fiche de présentation",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "for",
        "nom": "Formulaire de demande",
        "optionnel": false,
      },
      {
        "description": undefined,
        "id": "jpa",
        "nom": "Justificatif de paiement",
        "optionnel": true,
      },
      {
        "id": "lem",
        "nom": "Lettre de demande",
        "optionnel": true,
      },
      {
        "id": "let",
        "nom": "Lettre",
        "optionnel": true,
      },
      {
        "id": "noi",
        "nom": "Notice d'incidence",
        "optionnel": true,
      },
      {
        "id": "rec",
        "nom": "Récépissé "Loi sur l'eau"",
        "optionnel": true,
      },
      {
        "id": "aut",
        "nom": "Autre document",
        "optionnel": true,
      },
    ]
  `)

  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheIdValidator.parse('demarcheId'), firstEtapeDateValidator.parse('2022-01-01')),
      ETAPES_TYPES.demande,
      [],
      IS_ARM_MECANISE
    )
  ).toMatchInlineSnapshot(`
    [
      {
        "id": "cam",
        "nom": "Contrat d'amodiation",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "car",
        "nom": "Documents cartographiques",
        "optionnel": false,
      },
      {
        "id": "cnt",
        "nom": "Contrat",
        "optionnel": true,
      },
      {
        "id": "cod",
        "nom": "Compléments au dossier de demande",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "dep",
        "nom": "Décision cas par cas",
        "optionnel": false,
      },
      {
        "description": undefined,
        "id": "doe",
        "nom": "Dossier "Loi sur l'eau"",
        "optionnel": false,
      },
      {
        "description": undefined,
        "id": "dom",
        "nom": "Dossier de demande",
        "optionnel": false,
      },
      {
        "id": "dos",
        "nom": "Dossier",
        "optionnel": true,
      },
      {
        "id": "fac",
        "nom": "Facture",
        "optionnel": true,
      },
      {
        "id": "fic",
        "nom": "Fiche de complétude",
        "optionnel": true,
      },
      {
        "id": "fip",
        "nom": "Fiche de présentation",
        "optionnel": true,
      },
      {
        "description": undefined,
        "id": "for",
        "nom": "Formulaire de demande",
        "optionnel": false,
      },
      {
        "description": undefined,
        "id": "jpa",
        "nom": "Justificatif de paiement",
        "optionnel": true,
      },
      {
        "id": "lem",
        "nom": "Lettre de demande",
        "optionnel": true,
      },
      {
        "id": "let",
        "nom": "Lettre",
        "optionnel": true,
      },
      {
        "id": "noi",
        "nom": "Notice d'incidence",
        "optionnel": true,
      },
      {
        "id": "rec",
        "nom": "Récépissé "Loi sur l'eau"",
        "optionnel": true,
      },
      {
        "id": "aut",
        "nom": "Autre document",
        "optionnel": true,
      },
    ]
  `)
  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheIdValidator.parse('demarcheId'), firstEtapeDateValidator.parse('2024-10-01')),
      ETAPES_TYPES.demande,
      [],
      IS_ARM_MECANISE
    )
  ).toMatchInlineSnapshot(`
      [
        {
          "id": "cam",
          "nom": "Contrat d'amodiation",
          "optionnel": true,
        },
        {
          "description": undefined,
          "id": "car",
          "nom": "Documents cartographiques",
          "optionnel": false,
        },
        {
          "id": "cnt",
          "nom": "Contrat",
          "optionnel": true,
        },
        {
          "id": "cod",
          "nom": "Compléments au dossier de demande",
          "optionnel": true,
        },
        {
          "description": undefined,
          "id": "dep",
          "nom": "Décision cas par cas",
          "optionnel": true,
        },
        {
          "description": undefined,
          "id": "doe",
          "nom": "Dossier "Loi sur l'eau"",
          "optionnel": false,
        },
        {
          "description": undefined,
          "id": "dom",
          "nom": "Dossier de demande",
          "optionnel": false,
        },
        {
          "id": "dos",
          "nom": "Dossier",
          "optionnel": true,
        },
        {
          "id": "fac",
          "nom": "Facture",
          "optionnel": true,
        },
        {
          "id": "fic",
          "nom": "Fiche de complétude",
          "optionnel": true,
        },
        {
          "id": "fip",
          "nom": "Fiche de présentation",
          "optionnel": true,
        },
        {
          "description": undefined,
          "id": "for",
          "nom": "Formulaire de demande",
          "optionnel": false,
        },
        {
          "description": undefined,
          "id": "jpa",
          "nom": "Justificatif de paiement",
          "optionnel": true,
        },
        {
          "id": "lem",
          "nom": "Lettre de demande",
          "optionnel": true,
        },
        {
          "id": "let",
          "nom": "Lettre",
          "optionnel": true,
        },
        {
          "id": "noi",
          "nom": "Notice d'incidence",
          "optionnel": true,
        },
        {
          "id": "rec",
          "nom": "Récépissé "Loi sur l'eau"",
          "optionnel": true,
        },
        {
          "id": "aut",
          "nom": "Autre document",
          "optionnel": true,
        },
      ]
    `)
  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheIdValidator.parse('demarcheId'), firstEtapeDateValidator.parse('2022-01-01')),
      ETAPES_TYPES.demande,
      ['1'],
      IS_ARM_NON_MECANISE
    )
  ).toMatchSnapshot()
  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheIdValidator.parse('demarcheId'), firstEtapeDateValidator.parse('2022-01-01')),
      ETAPES_TYPES.demande,
      ['2'],
      IS_ARM_NON_MECANISE
    )
  ).toMatchSnapshot()
  expect(
    getDocuments(
      MachineInfo.withDate(TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheIdValidator.parse('demarcheId'), firstEtapeDateValidator.parse('2024-12-01')),
      ETAPES_TYPES.demande,
      ['2'],
      IS_ARM_NON_MECANISE
    )
  ).toMatchSnapshot()
})
