import { describe, expect, test } from 'vitest'
import { isArmMecanise, IS_ARM_NON_MECANISE, IS_ARM_MECANISE } from './mecanise'

describe('isArmMecanise', () => {
  test('retourne false pour un flattened contenu vide', () => {
    expect(isArmMecanise({})).toBe(IS_ARM_NON_MECANISE)
  })
  test('retourne false pour une ARM non mécanisée (flattened contenu)', () => {
    expect(isArmMecanise({ arm: { mecanise: { value: false, heritee: false, etapeHeritee: null } } })).toBe(IS_ARM_NON_MECANISE)
  })
  test('retourne true pour une ARM mécanisée (flattened contenu)', () => {
    expect(isArmMecanise({ arm: { mecanise: { value: true, heritee: false, etapeHeritee: null } } })).toBe(IS_ARM_MECANISE)
  })
  test('retourne false pour des sections with value vides', () => {
    expect(isArmMecanise([])).toBe(IS_ARM_NON_MECANISE)
  })
  test('retourne false pour une ARM non mécanisée (sections with value)', () => {
    expect(isArmMecanise([{ id: 'arm', elements: [{ id: 'mecanise', type: 'checkbox', optionnel: false, value: false }] }])).toBe(IS_ARM_NON_MECANISE)
  })
  test('retourne true pour une ARM mécanisée (sections with value)', () => {
    expect(isArmMecanise([{ id: 'arm', elements: [{ id: 'mecanise', type: 'checkbox', optionnel: false, value: true }] }])).toBe(IS_ARM_MECANISE)
  })
})
