/* v8 ignore next 8 */
import { z } from 'zod'
import { utilisateurIdValidator } from './roles'

const LOGS_METHODS = ['post', 'delete', 'put'] as const

export const logsMethodValidator = z.enum(LOGS_METHODS)
export type LogMethod = z.infer<typeof logsMethodValidator>

export const mutationIdValidator = z.string().uuid().brand('MUTATION_ID')
export type MutationId = z.infer<typeof mutationIdValidator>
export const mutationValidator = z.object({
  id: mutationIdValidator,
  datetime: z.string().datetime(),
  method: logsMethodValidator,
  path: z.string(),
  utilisateur_nom: z.string(),
  utilisateur_prenom: z.string(),
  utilisateur_id: utilisateurIdValidator,
  camino_path: z.string(),
  camino_variables: z.record(z.string(), z.string()),
})
export type Mutation = z.infer<typeof mutationValidator>

export const getMutationValidator = mutationValidator.extend({ body: z.string() })
export type GetMutation = z.infer<typeof getMutationValidator>
