import { NewPostRestRoutes, NewPutRestRoutes, DeleteRestRoutes, NewDeleteRestRoutes } from 'camino-common/src/rest'
import { Knex } from 'knex'

// On peut trouver toutes les routes qui mutent avec PostRestRoutes | NewPostRestRoutes | NewPutRestRoutes | DeleteRestRoutes | NewDeleteRestRoutes
export const up = async (knex: Knex): Promise<void> => {
  await knex.raw('alter table logs add column id uuid DEFAULT gen_random_uuid() PRIMARY KEY')
  await knex.raw('alter table logs add column camino_path varchar')
  await knex.raw('alter table logs add column camino_variables jsonb')

  const logs: { rows: { id: string; datetime: Date; path: string; method: string; body: string; utilisateur_id: string }[] } = await knex.raw('select * from logs')

  for (const log of logs.rows) {
    let camino_path: NewPostRestRoutes | NewPutRestRoutes | DeleteRestRoutes | NewDeleteRestRoutes
    let camino_variables: Record<string, string> = {}
    if (log.path.endsWith('/permission')) {
      camino_path = '/rest/utilisateurs/:id/permission'
      camino_variables = { id: log.path.split('/')[3] }
    } else if (log.path.endsWith('/abonne')) {
      camino_path = '/rest/titres/:titreId/abonne'
      camino_variables = { titreId: log.path.split('/')[3] }
    } else if (log.path.endsWith('/titreLiaisons')) {
      camino_path = '/rest/titres/:id/titreLiaisons'
      camino_variables = { id: log.path.split('/')[3] }
    } else if (log.path.startsWith('/rest/activites/')) {
      camino_path = '/rest/activites/:activiteId'
      camino_variables = { activiteId: log.path.split('/')[3] }
    } else if (log.path.endsWith('/depot')) {
      camino_path = '/rest/etapes/:etapeId/depot'
      camino_variables = { etapeId: log.path.split('/')[3] }
    } else if (log.path.endsWith('/activiteTypeEmails/delete')) {
      camino_path = '/rest/administrations/:administrationId/activiteTypeEmails/delete'
      camino_variables = { administrationId: log.path.split('/')[3] }
    } else if (log.path.endsWith('/activiteTypeEmails')) {
      camino_path = '/rest/administrations/:administrationId/activiteTypeEmails'
      camino_variables = { administrationId: log.path.split('/')[3] }
    } else if (log.path.endsWith('/documents')) {
      camino_path = '/rest/entreprises/:entrepriseId/documents'
      camino_variables = { entrepriseId: log.path.split('/')[3] }
    } else if (log.path.startsWith('/rest/entreprises/') && log.path.includes('/documents/')) {
      camino_path = '/rest/entreprises/:entrepriseId/documents/:entrepriseDocumentId'
      camino_variables = { entrepriseId: log.path.split('/')[3], entrepriseDocumentId: log.path.split('/')[5] }
    } else if (log.path.startsWith('/rest/entreprises/')) {
      camino_path = '/rest/entreprises/:entrepriseId'
      camino_variables = { entrepriseId: log.path.split('/')[3] }
    } else if (log.path.startsWith('/rest/titres/')) {
      camino_path = '/rest/titres/:titreId'
      camino_variables = { titreId: log.path.split('/')[3] }
    } else if (log.path.startsWith('/rest/demarches/')) {
      camino_path = '/rest/demarches/:demarcheIdOrSlug'
      camino_variables = { demarcheIdOrSlug: log.path.split('/')[3] }
    } else if (log.path.startsWith('/rest/etapes/')) {
      camino_path = '/rest/etapes/:etapeIdOrSlug'
      camino_variables = { etapeIdOrSlug: log.path.split('/')[3] }
    } else if (log.path.startsWith('/rest/geojson/import/')) {
      camino_path = '/rest/geojson/import/:geoSystemeId'
    } else if (log.path.startsWith('/rest/geojson_forages/import/')) {
      camino_path = '/rest/geojson_forages/import/:geoSystemeId'
    } else if (log.path.startsWith('/rest/geojson_points/import/')) {
      camino_path = '/rest/geojson_points/import/:geoSystemeId'
    } else {
      camino_path = log.path as NewPostRestRoutes
    }

    await knex.raw('UPDATE logs SET camino_path=?, camino_variables=? WHERE id=?', [camino_path, camino_variables, log.id])
  }

  await knex.raw('ALTER TABLE logs ALTER COLUMN camino_path set not null')
  await knex.raw('ALTER TABLE logs ALTER COLUMN camino_variables set not null')
}

export const down = (): void => {}
