import { describe, expect, test } from 'vitest'

import { ApiMachineInfo, demarcheEnregistrementDemandeDateFind } from './machines'
import { isNotNullNorUndefined, isNullOrUndefined } from 'camino-common/src/typescript-tools'
import { DemarcheWithEtapeForMachinesTest } from '../../tools/demarches/tests-creation'
import { MachineInfo } from 'camino-common/src/machines'
import { toCaminoDate } from 'camino-common/src/date'
import { ETAPES_TYPES } from 'camino-common/src/static/etapesTypes'
const etapesProdSpecifiqueArmAxm = require('./machines-cases.json') // eslint-disable-line

// pour regénérer le machines-cases.json: `npm run test:generate-data -w packages/api`
test.each(etapesProdSpecifiqueArmAxm as DemarcheWithEtapeForMachinesTest[])('cas réel N°$id', demarche => {
  const firstEtapeDate = demarcheEnregistrementDemandeDateFind(demarche.etapes.map(etape => ({ ...etape, typeId: etape.etapeTypeId })))
  let machine: ApiMachineInfo | undefined
  if (isNotNullNorUndefined(firstEtapeDate)) {
    machine = new ApiMachineInfo(MachineInfo.withDate(demarche.titreTypeId, demarche.demarcheTypeId, demarche.id, firstEtapeDate))
  }
  if (isNullOrUndefined(machine) || isNullOrUndefined(machine.machine)) {
    throw new Error(`Impossible de trouver une machine alors qu'on aurait du avoir ${demarche.machineId}, ${demarche.id}`)
  }
  machine.machine.interpretMachine(demarche.etapes)
  expect(machine.machine.demarcheStatut(demarche.etapes), `${demarche.machineId}`).toStrictEqual(demarche.statut)
})

describe('demarcheEnregistrementDemandeDateFind', () => {
  test("pas d'étapes", () => {
    expect(demarcheEnregistrementDemandeDateFind([])).toBe(null)
  })

  test('un enregistrement de la demande', () => {
    expect(
      demarcheEnregistrementDemandeDateFind([
        { typeId: ETAPES_TYPES.demande, date: toCaminoDate('2020-01-01') },
        { typeId: ETAPES_TYPES.enregistrementDeLaDemande, date: toCaminoDate('2024-01-01') },
      ])
    ).toBe(toCaminoDate('2024-01-01'))
  })
  test('sans enregistrement de la demande', () => {
    expect(
      demarcheEnregistrementDemandeDateFind([
        { typeId: ETAPES_TYPES.demande, date: toCaminoDate('2020-01-01') },
        { typeId: ETAPES_TYPES.abrogationDeLaDecision, date: toCaminoDate('2024-01-01') },
      ])
    ).toBe(toCaminoDate('2020-01-01'))
  })
})
