import { Pool } from 'pg'
import { EtapeId, getStatutId } from 'camino-common/src/etape'
import { getCurrent } from 'camino-common/src/date'
import { EtapeStatutId } from 'camino-common/src/static/etapesStatuts'
import { getEtapesWithAutomaticStatut, updateEtapeStatut } from '../../database/queries/titres-etapes.queries'
import { simpleContenuToFlattenedContenu } from 'camino-common/src/sections'
import { MachineInfo } from 'camino-common/src/machines'

export const titresEtapesStatutUpdate = async (pool: Pool): Promise<EtapeId[]> => {
  console.info()
  console.info('statut des étapes…')

  const titresEtapesIdsUpdated: EtapeId[] = []

  const currentDate = getCurrent()
  const etapesWithAutomaticStatut = await getEtapesWithAutomaticStatut(pool)

  for (const etape of etapesWithAutomaticStatut) {
    const machineInfo = MachineInfo.withMachineId(etape.titre_type_id, etape.demarche_type_id, etape.demarche_id, etape.demarche_machine_id)
    if (!machineInfo.valid) {
      throw new Error(`La machine associée à la démarche est incohérente: ${machineInfo.error}`)
    }

    const newStatut: EtapeStatutId = getStatutId(
      {
        ...etape,
        statutId: etape.etape_statut_id,
        typeId: etape.type_id,
        contenu: simpleContenuToFlattenedContenu(machineInfo.value, etape.type_id, etape.contenu, etape.heritage_contenu),
      },
      currentDate
    )

    if (newStatut !== etape.etape_statut_id) {
      await updateEtapeStatut(pool, etape.id, newStatut)
      console.info('titre / démarche / étape : statut (mise à jour) ->', `${etape.id} : ${etape.etape_statut_id} => ${newStatut}`)

      titresEtapesIdsUpdated.push(etape.id)
    }
  }

  return titresEtapesIdsUpdated
}
