import { TitreId } from 'camino-common/src/validators/titres'
import { titreDemarcheUpdate } from '../../database/queries/titres-demarches'
import { titreDemarcheStatutIdFind } from '../rules/titre-demarche-statut-id-find'
import { titreEtapesSortAscByOrdre } from '../utils/titre-etapes-sort'
import { getDemarches } from './titres-etapes-heritage-contenu-update.queries'
import { Pool } from 'pg'
import { callAndExit } from '../../tools/fp-tools'
import { MachineInfo } from 'camino-common/src/machines'

export const titresDemarchesStatutIdUpdate = async (pool: Pool, titreId?: TitreId): Promise<string[]> => {
  console.info()
  console.info('statut des démarches…')

  const titresDemarches = await callAndExit(getDemarches(pool, undefined, titreId))

  const titresDemarchesUpdated: string[] = []

  for (const titreDemarche of Object.values(titresDemarches)) {
    const titreDemarcheEtapes = titreEtapesSortAscByOrdre(titreDemarche.etapes)

    const machineInfo = MachineInfo.withMachineId(titreDemarche.titreTypeId, titreDemarche.typeId, titreDemarche.id, titreDemarche.machineId)
    if (!machineInfo.valid) {
      throw new Error(`La machine associée à la démarche est incohérente: ${machineInfo.error}`)
    }

    const statutId = titreDemarcheStatutIdFind(machineInfo.value, titreDemarcheEtapes)

    if (titreDemarche.statutId !== statutId) {
      await titreDemarcheUpdate(titreDemarche.id, { statutId })

      console.info('titre / démarche : statut (mise à jour) ->', `${titreDemarche.slug}: ${statutId}`)

      titresDemarchesUpdated.push(titreDemarche.id)
    }
  }

  return titresDemarchesUpdated
}
