import { dbManager } from '../../../tests/db-manager'
import { restNewCall } from '../../../tests/_utils/index'
import { ADMINISTRATION_IDS } from 'camino-common/src/static/administrations'
import { afterAll, beforeAll, describe, test, expect, vi } from 'vitest'
import type { Pool } from 'pg'
import { newTitreId } from '../../database/models/_format/id-create'
import { insertTitreGraph } from '../../../tests/integration-test-helper'

console.info = vi.fn()
console.error = vi.fn()

let dbPool: Pool
beforeAll(async () => {
  const { pool } = await dbManager.populateDb()
  dbPool = pool
})

afterAll(async () => {
  await dbManager.closeKnex()
})

describe('quickAccess', () => {
  test('par référence', async () => {
    const reference = 'refTest'
    await insertTitreGraph({
      id: newTitreId('id-par-reference'),
      nom: 'Nom-par-référence',
      typeId: 'arm',
      titreStatutId: 'val',
      propsTitreEtapesIds: {},
      publicLecture: true,
      references: [{ nom: reference, referenceTypeId: 'brg' }],
    })
    const tested = await restNewCall(
      dbPool,
      '/rest/quickAccess',
      {},
      {
        role: 'admin',
        administrationId: ADMINISTRATION_IDS['DGTM - GUYANE'],
      },
      { search: reference }
    )

    expect(tested.body).toMatchInlineSnapshot(`
      [
        {
          "id": "id-par-reference",
          "nom": "Nom-par-référence",
          "titreDateDebut": null,
          "typeId": "arm",
        },
      ]
    `)
  })

  test('par nom', async () => {
    await insertTitreGraph({
      id: newTitreId('id-titre-avec-accents'),
      nom: 'Titre avÉc des Accènts',
      typeId: 'arm',
      titreStatutId: 'val',
      propsTitreEtapesIds: {},
      publicLecture: true,
    })
    const tested = await restNewCall(
      dbPool,
      '/rest/quickAccess',
      {},
      {
        role: 'admin',
        administrationId: ADMINISTRATION_IDS['DGTM - GUYANE'],
      },
      { search: 'avec des acc' }
    )

    expect(tested.body).toMatchInlineSnapshot(`
        [
          {
            "id": "id-titre-avec-accents",
            "nom": "Titre avÉc des Accènts",
            "titreDateDebut": null,
            "typeId": "arm",
          },
        ]
      `)
  })
  test('droits insuffisants', async () => {
    await insertTitreGraph({
      id: newTitreId('id-titre-filtré'),
      nom: 'titre filtré',
      typeId: 'arm',
      titreStatutId: 'val',
      propsTitreEtapesIds: {},
      publicLecture: false,
    })
    const tested = await restNewCall(
      dbPool,
      '/rest/quickAccess',
      {},
      {
        role: 'defaut',
      },
      { search: 'filtre' }
    )

    expect(tested.body).toMatchInlineSnapshot(`[]`)
  })
})
