/** Types generated for queries found in "src/api/rest/mutations.queries.ts" */
export type Json = null | boolean | number | string | Json[] | { [key: string]: Json };

/** 'GetMutationsDb' parameters type */
export interface IGetMutationsDbParams {
  email?: string | null | void;
}

/** 'GetMutationsDb' return type */
export interface IGetMutationsDbResult {
  camino_path: string;
  camino_variables: Json;
  datetime: Date;
  id: string;
  method: string;
  path: string | null;
  utilisateur_id: string;
  utilisateur_nom: string | null;
  utilisateur_prenom: string | null;
}

/** 'GetMutationsDb' query type */
export interface IGetMutationsDbQuery {
  params: IGetMutationsDbParams;
  result: IGetMutationsDbResult;
}

/** 'GetMutationDb' parameters type */
export interface IGetMutationDbParams {
  mutationId: string;
}

/** 'GetMutationDb' return type */
export interface IGetMutationDbResult {
  body: Json | null;
  camino_path: string;
  camino_variables: Json;
  datetime: Date;
  id: string;
  method: string;
  path: string | null;
  utilisateur_id: string;
  utilisateur_nom: string | null;
  utilisateur_prenom: string | null;
}

/** 'GetMutationDb' query type */
export interface IGetMutationDbQuery {
  params: IGetMutationDbParams;
  result: IGetMutationDbResult;
}

