/*
 * Decompiled with CFR 0.152.
 */
package fr.insee.keycloak.providers.franceconnect;

import com.fasterxml.jackson.databind.JsonNode;
import fr.insee.keycloak.providers.common.AbstractBaseIdentityProvider;
import fr.insee.keycloak.providers.common.EidasLevel;
import fr.insee.keycloak.providers.common.Utils;
import fr.insee.keycloak.providers.franceconnect.FranceConnectIdentityProviderConfig;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.security.Key;
import java.util.Optional;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.JsonSerialization;

final class FranceConnectIdentityProvider
extends AbstractBaseIdentityProvider<FranceConnectIdentityProviderConfig> {
    private static final String BROKER_NONCE_PARAM = "BROKER_NONCE";
    private static final MediaType APPLICATION_JWT_TYPE = MediaType.valueOf((String)"application/jwt");

    FranceConnectIdentityProvider(KeycloakSession session, FranceConnectIdentityProviderConfig config) {
        super(session, config, FranceConnectIdentityProvider.useJwks(config) ? Utils.getJsonWebKeySetFrom(config.getJwksUrl(), session) : null);
    }

    private static boolean useJwks(FranceConnectIdentityProviderConfig config) {
        return config.isUseJwksUrl() && config.getJwksUrl() != null;
    }

    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        FranceConnectIdentityProviderConfig config = (FranceConnectIdentityProviderConfig)((Object)this.getConfig());
        AuthenticationSessionModel authenticationSession = request.getAuthenticationSession();
        authenticationSession.setClientNote("acr_values", config.getEidasLevel().toString());
        UriBuilder uriBuilder = super.createAuthorizationUrl(request);
        String nonce = DatatypeConverter.printHexBinary((byte[])Utils.generateRandomBytes(32));
        authenticationSession.setClientNote(BROKER_NONCE_PARAM, nonce);
        uriBuilder.replaceQueryParam("nonce", new Object[]{nonce});
        logger.debugv("FC Authorization Url: {0}", (Object)uriBuilder.build(new Object[0]).toString());
        return uriBuilder;
    }

    @Override
    public String getIdTokenForLogout(UserSessionModel userSession) {
        String idToken = super.getIdTokenForLogout(userSession);
        return this.isJWETokenFormatRequired((FranceConnectIdentityProviderConfig)((Object)this.getConfig())) ? this.decryptJWE(idToken) : idToken;
    }

    public JsonWebToken validateToken(String encodedToken) {
        boolean ignoreAudience = false;
        String token = this.isJWETokenFormatRequired((FranceConnectIdentityProviderConfig)((Object)this.getConfig())) ? this.decryptJWE(encodedToken) : encodedToken;
        return this.validateToken(token, ignoreAudience);
    }

    protected BrokeredIdentityContext extractIdentity(AccessTokenResponse tokenResponse, String accessToken, JsonWebToken idToken) throws IOException {
        String userInfoUrl;
        FranceConnectIdentityProviderConfig config = (FranceConnectIdentityProviderConfig)((Object)this.getConfig());
        String id = idToken.getSubject();
        BrokeredIdentityContext identity = new BrokeredIdentityContext(id, (IdentityProviderModel)config);
        String name = (String)idToken.getOtherClaims().get("name");
        String givenName = (String)idToken.getOtherClaims().get("given_name");
        String familyName = (String)idToken.getOtherClaims().get("family_name");
        String preferredUsername = (String)idToken.getOtherClaims().get(this.getusernameClaimNameForIdToken());
        String email = (String)idToken.getOtherClaims().get("email");
        if (!((FranceConnectIdentityProviderConfig)((Object)this.getConfig())).isDisableUserInfoService() && (userInfoUrl = this.getUserInfoUrl()) != null && !userInfoUrl.isEmpty() && accessToken != null) {
            JsonNode userInfo;
            MediaType contentMediaType;
            SimpleHttp.Response response = this.executeRequest(userInfoUrl, SimpleHttp.doGet((String)userInfoUrl, (KeycloakSession)this.session).header("Authorization", "Bearer " + accessToken));
            String contentType = response.getFirstHeader("Content-Type");
            try {
                contentMediaType = MediaType.valueOf((String)contentType);
            }
            catch (IllegalArgumentException ex) {
                contentMediaType = null;
            }
            if (contentMediaType == null || contentMediaType.isWildcardSubtype() || contentMediaType.isWildcardType()) {
                throw new RuntimeException("Unsupported content-type [" + contentType + "] in response from [" + userInfoUrl + "].");
            }
            if (MediaType.APPLICATION_JSON_TYPE.isCompatible(contentMediaType)) {
                userInfo = response.asJson();
            } else if (APPLICATION_JWT_TYPE.isCompatible(contentMediaType)) {
                try {
                    String jwt = this.isJWETokenFormatRequired((FranceConnectIdentityProviderConfig)((Object)this.getConfig())) ? this.decryptJWE(response.asString()) : response.asString();
                    userInfo = this.getJsonFromJWT(jwt);
                }
                catch (IdentityBrokerException ex) {
                    throw new RuntimeException("Failed to verify signature of userinfo response from [" + userInfoUrl + "].", ex);
                }
            } else {
                throw new RuntimeException("Unsupported content-type [" + contentType + "] in response from [" + userInfoUrl + "].");
            }
            id = this.getJsonProperty(userInfo, "sub");
            name = this.getJsonProperty(userInfo, "name");
            givenName = this.getJsonProperty(userInfo, "given_name");
            familyName = this.getJsonProperty(userInfo, "family_name");
            preferredUsername = this.getUsernameFromUserInfo(userInfo);
            email = this.getJsonProperty(userInfo, "email");
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper((BrokeredIdentityContext)identity, (JsonNode)userInfo, (String)((FranceConnectIdentityProviderConfig)((Object)this.getConfig())).getAlias());
        }
        identity.setId(id);
        identity.getContextData().put("VALIDATED_ID_TOKEN", idToken);
        identity.setFirstName(givenName);
        identity.setLastName(familyName);
        if (givenName == null && familyName == null) {
            identity.setName(name);
        }
        identity.setEmail(email);
        identity.setBrokerUserId(((FranceConnectIdentityProviderConfig)((Object)this.getConfig())).getAlias() + "." + id);
        Optional<String> emailOptional = Optional.ofNullable(email);
        preferredUsername = Optional.ofNullable(preferredUsername).or(() -> emailOptional).orElse(id);
        identity.setUsername(preferredUsername);
        if (tokenResponse != null && tokenResponse.getSessionState() != null) {
            identity.setBrokerSessionId(((FranceConnectIdentityProviderConfig)((Object)this.getConfig())).getAlias() + "." + tokenResponse.getSessionState());
        }
        if (tokenResponse != null) {
            identity.getContextData().put("FEDERATED_ACCESS_TOKEN_RESPONSE", tokenResponse);
            this.processAccessTokenResponse(identity, tokenResponse);
        }
        return identity;
    }

    private boolean isJWETokenFormatRequired(FranceConnectIdentityProviderConfig config) {
        EidasLevel eidasLevel = config.getEidasLevel();
        return !EidasLevel.EIDAS1.equals((Object)eidasLevel) && FranceConnectIdentityProvider.useJwks(config);
    }

    private String decryptJWE(String encryptedJWE) {
        try {
            JWE jwe = new JWE(encryptedJWE);
            String kid = jwe.getHeader().getKeyId();
            Key key = this.session.keys().getKeysStream(this.session.getContext().getRealm()).filter(k -> k.getKid().equalsIgnoreCase(kid)).findFirst().map(KeyWrapper::getPrivateKey).orElseThrow(() -> new IdentityBrokerException("No key found for kid " + kid));
            logger.debug((Object)("Found corresponding secret key for kid " + kid));
            jwe.getKeyStorage().setDecryptionKey(key);
            return new String(jwe.verifyAndDecodeJwe().getContent());
        }
        catch (JWEException ex) {
            throw new IdentityBrokerException("Invalid token", (Throwable)ex);
        }
    }

    private SimpleHttp.Response executeRequest(String url, SimpleHttp request) throws IOException {
        SimpleHttp.Response response = request.asResponse();
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw new IdentityBrokerException("Failed to invoke url [" + url + "]: " + response.asString());
        }
        return response;
    }

    private JsonNode getJsonFromJWT(String jwt) throws IdentityBrokerException {
        JWSInput jwsInput;
        try {
            jwsInput = new JWSInput(jwt);
        }
        catch (JWSInputException cause) {
            throw new IdentityBrokerException("Failed to parse JWT userinfo response", (Throwable)cause);
        }
        if (!this.verify(jwsInput)) {
            throw new IdentityBrokerException("Failed to verify signature of of jwt");
        }
        try {
            return (JsonNode)JsonSerialization.readValue((byte[])jwsInput.getContent(), JsonNode.class);
        }
        catch (IOException e) {
            throw new IdentityBrokerException("Failed to parse jwt", (Throwable)e);
        }
    }
}

