import { describe, test, expect } from 'vitest'
import { getAvisTypes } from './avisTypes'
import { firstEtapeDateValidator } from './date'
import { demarcheIdValidator } from './demarche'
import { communeIdValidator } from './static/communes'
import { DEMARCHES_TYPES_IDS } from './static/demarchesTypes'
import { ETAPES_TYPES } from './static/etapesTypes'
import { IS_ARM_MECANISE } from './static/mecanise'
import { TITRES_TYPES_IDS } from './static/titresTypes'

describe('getAvisType', () => {
  const demarcheId = demarcheIdValidator.parse('demarcheId')
  const firstEtapeDate = firstEtapeDateValidator.parse('2022-01-01')

  test("les avis obligatoires deviennent optionnels si on n'a pas de machine", () => {
    const avis = getAvisTypes(
      ETAPES_TYPES.demande,
      TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX,
      DEMARCHES_TYPES_IDS.Octroi,
      demarcheId,
      firstEtapeDateValidator.parse('1980-11-01'),
      [],
      IS_ARM_MECANISE
    )
    expect(avis).toMatchInlineSnapshot(`
      {
        "avisDeLaMissionAutoriteEnvironnementale": {
          "id": "avisDeLaMissionAutoriteEnvironnementale",
          "optionnel": true,
        },
        "avisProprietaireDuSol": {
          "id": "avisProprietaireDuSol",
          "optionnel": true,
        },
      }
    `)
  })

  test("avis de l'office national des forêts est optionnel pour la procédure spécifique", () => {
    const avis = getAvisTypes(
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX,
      DEMARCHES_TYPES_IDS.Octroi,
      demarcheId,
      firstEtapeDateValidator.parse('2024-11-01'),
      [],
      IS_ARM_MECANISE
    )
    expect(avis.avisOfficeNationalDesForets?.optionnel).toBe(true)
  })
  test("avis au cas par cas et avis du propriétaire du sol sont obligatoires pour les demandes d'ARM mécanisée de la procédure spécifique", () => {
    expect(getAvisTypes(ETAPES_TYPES.demande, TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate, [], IS_ARM_MECANISE)).toMatchInlineSnapshot(
      `{}`
    )
    expect(
      getAvisTypes(ETAPES_TYPES.demande, TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDateValidator.parse('2025-01-01'), [], IS_ARM_MECANISE)
    ).toMatchInlineSnapshot(`
      {
        "avisCasParCas": {
          "id": "avisCasParCas",
          "optionnel": false,
        },
        "avisProprietaireDuSol": {
          "id": "avisProprietaireDuSol",
          "optionnel": false,
        },
      }
    `)
  })
  test('les avis CGE et AE sont obligatoires pour la machine spécifique', () => {
    expect(getAvisTypes(ETAPES_TYPES.saisinesEtAvisCGE_AE, TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate, [], IS_ARM_MECANISE))
      .toMatchInlineSnapshot(`
      {
        "autreAvis": {
          "id": "autreAvis",
          "optionnel": true,
        },
        "avisDeLaMissionAutoriteEnvironnementale": {
          "id": "avisDeLaMissionAutoriteEnvironnementale",
          "optionnel": true,
        },
        "avisDuConseilGeneralDeLEconomie": {
          "id": "avisDuConseilGeneralDeLEconomie",
          "optionnel": true,
        },
      }
    `)
    expect(
      getAvisTypes(
        ETAPES_TYPES.saisinesEtAvisCGE_AE,
        TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX,
        DEMARCHES_TYPES_IDS.Octroi,
        demarcheId,
        firstEtapeDateValidator.parse('2025-01-01'),
        [],
        IS_ARM_MECANISE
      )
    ).toMatchInlineSnapshot(`
      {
        "autreAvis": {
          "id": "autreAvis",
          "optionnel": true,
        },
        "avisDeLaMissionAutoriteEnvironnementale": {
          "id": "avisDeLaMissionAutoriteEnvironnementale",
          "optionnel": false,
        },
        "avisDuConseilGeneralDeLEconomie": {
          "id": "avisDuConseilGeneralDeLEconomie",
          "optionnel": false,
        },
      }
    `)
  })
  test('getAvisType', () => {
    expect(getAvisTypes(ETAPES_TYPES.avisDesCollectivites, TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate, [], IS_ARM_MECANISE))
      .toMatchInlineSnapshot(`
        {
          "avisDUneCollectivite": {
            "id": "avisDUneCollectivite",
            "optionnel": true,
          },
        }
      `)
    expect(getAvisTypes(ETAPES_TYPES.demande, TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX, DEMARCHES_TYPES_IDS.Octroi, demarcheId, firstEtapeDate, [], IS_ARM_MECANISE)).toMatchInlineSnapshot(
      `{}`
    )
    expect(
      getAvisTypes(
        ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
        TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX,
        DEMARCHES_TYPES_IDS.Octroi,
        demarcheId,
        firstEtapeDate,
        [],
        IS_ARM_MECANISE
      )
    ).toMatchInlineSnapshot(`
      {
        "autreAvis": {
          "id": "autreAvis",
          "optionnel": true,
        },
        "avisAgenceRegionaleSante": {
          "id": "avisAgenceRegionaleSante",
          "optionnel": true,
        },
        "avisAutoriteMilitaire": {
          "id": "avisAutoriteMilitaire",
          "optionnel": true,
        },
        "avisCaisseGeneraleSecuriteSociale": {
          "id": "avisCaisseGeneraleSecuriteSociale",
          "optionnel": true,
        },
        "avisConseilDepartementalEnvironnementRisquesSanitairesTechnologiques": {
          "id": "avisConseilDepartementalEnvironnementRisquesSanitairesTechnologiques",
          "optionnel": true,
        },
        "avisDirectionDepartementaleTerritoiresMer": {
          "id": "avisDirectionDepartementaleTerritoiresMer",
          "optionnel": true,
        },
        "avisDirectionRegionaleDesAffairesCulturelles": {
          "id": "avisDirectionRegionaleDesAffairesCulturelles",
          "optionnel": true,
        },
        "avisDirectionRegionaleFinancesPubliques": {
          "id": "avisDirectionRegionaleFinancesPubliques",
          "optionnel": true,
        },
        "avisDirectionsRégionalesEconomieEmploiTravailSolidarités": {
          "id": "avisDirectionsRégionalesEconomieEmploiTravailSolidarités",
          "optionnel": true,
        },
        "avisGendarmerieNationale": {
          "id": "avisGendarmerieNationale",
          "optionnel": true,
        },
        "avisIFREMER": {
          "id": "avisIFREMER",
          "optionnel": true,
        },
        "avisInstitutNationalOrigineQualite": {
          "id": "avisInstitutNationalOrigineQualite",
          "optionnel": true,
        },
        "avisOfficeNationalDesForets": {
          "id": "avisOfficeNationalDesForets",
          "optionnel": false,
        },
        "avisParcNational": {
          "id": "avisParcNational",
          "optionnel": true,
        },
        "avisParcNaturelMarin": {
          "id": "avisParcNaturelMarin",
          "optionnel": true,
        },
        "avisServiceAdministratifLocal": {
          "id": "avisServiceAdministratifLocal",
          "optionnel": true,
        },
        "expertiseOfficeNationalDesForets": {
          "id": "expertiseOfficeNationalDesForets",
          "optionnel": true,
        },
      }
    `)
    expect(
      getAvisTypes(
        ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
        TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX,
        DEMARCHES_TYPES_IDS.Octroi,
        demarcheId,
        firstEtapeDate,
        [communeIdValidator.parse('97302')],
        IS_ARM_MECANISE
      )
    ).toMatchInlineSnapshot(`
      {
        "autreAvis": {
          "id": "autreAvis",
          "optionnel": true,
        },
        "avisAgenceRegionaleSante": {
          "id": "avisAgenceRegionaleSante",
          "optionnel": true,
        },
        "avisAutoriteMilitaire": {
          "id": "avisAutoriteMilitaire",
          "optionnel": true,
        },
        "avisCaisseGeneraleSecuriteSociale": {
          "id": "avisCaisseGeneraleSecuriteSociale",
          "optionnel": true,
        },
        "avisConseilDepartementalEnvironnementRisquesSanitairesTechnologiques": {
          "id": "avisConseilDepartementalEnvironnementRisquesSanitairesTechnologiques",
          "optionnel": true,
        },
        "avisDirectionAlimentationAgricultureForet": {
          "id": "avisDirectionAlimentationAgricultureForet",
          "optionnel": true,
        },
        "avisDirectionDepartementaleTerritoiresMer": {
          "id": "avisDirectionDepartementaleTerritoiresMer",
          "optionnel": true,
        },
        "avisDirectionRegionaleDesAffairesCulturelles": {
          "id": "avisDirectionRegionaleDesAffairesCulturelles",
          "optionnel": true,
        },
        "avisDirectionRegionaleFinancesPubliques": {
          "id": "avisDirectionRegionaleFinancesPubliques",
          "optionnel": true,
        },
        "avisDirectionsRégionalesEconomieEmploiTravailSolidarités": {
          "id": "avisDirectionsRégionalesEconomieEmploiTravailSolidarités",
          "optionnel": true,
        },
        "avisEtatMajorOrpaillagePecheIllicite": {
          "id": "avisEtatMajorOrpaillagePecheIllicite",
          "optionnel": true,
        },
        "avisGendarmerieNationale": {
          "id": "avisGendarmerieNationale",
          "optionnel": true,
        },
        "avisIFREMER": {
          "id": "avisIFREMER",
          "optionnel": true,
        },
        "avisInstitutNationalOrigineQualite": {
          "id": "avisInstitutNationalOrigineQualite",
          "optionnel": true,
        },
        "avisOfficeNationalDesForets": {
          "id": "avisOfficeNationalDesForets",
          "optionnel": false,
        },
        "avisParcNational": {
          "id": "avisParcNational",
          "optionnel": true,
        },
        "avisParcNaturelMarin": {
          "id": "avisParcNaturelMarin",
          "optionnel": true,
        },
        "avisServiceAdministratifLocal": {
          "id": "avisServiceAdministratifLocal",
          "optionnel": true,
        },
        "expertiseOfficeNationalDesForets": {
          "id": "expertiseOfficeNationalDesForets",
          "optionnel": true,
        },
      }
    `)
    expect(
      getAvisTypes(
        ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
        TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX,
        DEMARCHES_TYPES_IDS.Octroi,
        demarcheId,
        firstEtapeDate,
        [communeIdValidator.parse('97302')],
        IS_ARM_MECANISE
      )
    ).toMatchInlineSnapshot(`
      {
        "autreAvis": {
          "id": "autreAvis",
          "optionnel": true,
        },
        "avisAgenceRegionaleSante": {
          "id": "avisAgenceRegionaleSante",
          "optionnel": true,
        },
        "avisAutoriteMilitaire": {
          "id": "avisAutoriteMilitaire",
          "optionnel": true,
        },
        "avisCaisseGeneraleSecuriteSociale": {
          "id": "avisCaisseGeneraleSecuriteSociale",
          "optionnel": true,
        },
        "avisConseilDepartementalEnvironnementRisquesSanitairesTechnologiques": {
          "id": "avisConseilDepartementalEnvironnementRisquesSanitairesTechnologiques",
          "optionnel": true,
        },
        "avisDirectionAlimentationAgricultureForet": {
          "id": "avisDirectionAlimentationAgricultureForet",
          "optionnel": true,
        },
        "avisDirectionDepartementaleTerritoiresMer": {
          "id": "avisDirectionDepartementaleTerritoiresMer",
          "optionnel": true,
        },
        "avisDirectionRegionaleDesAffairesCulturelles": {
          "id": "avisDirectionRegionaleDesAffairesCulturelles",
          "optionnel": true,
        },
        "avisDirectionRegionaleFinancesPubliques": {
          "id": "avisDirectionRegionaleFinancesPubliques",
          "optionnel": true,
        },
        "avisDirectionsRégionalesEconomieEmploiTravailSolidarités": {
          "id": "avisDirectionsRégionalesEconomieEmploiTravailSolidarités",
          "optionnel": true,
        },
        "avisEtatMajorOrpaillagePecheIllicite": {
          "id": "avisEtatMajorOrpaillagePecheIllicite",
          "optionnel": true,
        },
        "avisGendarmerieNationale": {
          "id": "avisGendarmerieNationale",
          "optionnel": true,
        },
        "avisIFREMER": {
          "id": "avisIFREMER",
          "optionnel": true,
        },
        "avisInstitutNationalOrigineQualite": {
          "id": "avisInstitutNationalOrigineQualite",
          "optionnel": true,
        },
        "avisOfficeNationalDesForets": {
          "id": "avisOfficeNationalDesForets",
          "optionnel": true,
        },
        "avisParcNational": {
          "id": "avisParcNational",
          "optionnel": true,
        },
        "avisParcNaturelMarin": {
          "id": "avisParcNaturelMarin",
          "optionnel": true,
        },
        "avisServiceAdministratifLocal": {
          "id": "avisServiceAdministratifLocal",
          "optionnel": true,
        },
        "confirmationAccordProprietaireDuSol": {
          "id": "confirmationAccordProprietaireDuSol",
          "optionnel": true,
        },
        "expertiseOfficeNationalDesForets": {
          "id": "expertiseOfficeNationalDesForets",
          "optionnel": true,
        },
      }
    `)
    expect(
      getAvisTypes(
        ETAPES_TYPES.consultationDesAdministrationsCentrales,
        TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_GRANULATS_MARINS,
        DEMARCHES_TYPES_IDS.Octroi,
        demarcheId,
        firstEtapeDate,
        [],
        IS_ARM_MECANISE
      )
    ).toMatchInlineSnapshot(`
      {
        "autreAvis": {
          "id": "autreAvis",
          "optionnel": true,
        },
      }
    `)
  })
})
