import { z } from 'zod'
import type { FlattenedContenu } from '../etape-form'
import type { SectionWithValue } from '../sections'

const isArmMecaniseValidator = z.boolean().brand('ARM_MECANISE')
export type IsArmMecanise = z.infer<typeof isArmMecaniseValidator>

export const IS_ARM_MECANISE = true as const as IsArmMecanise
export const IS_ARM_NON_MECANISE = false as const as IsArmMecanise

export const isArmMecanise = (contenu: FlattenedContenu | SectionWithValue[]): IsArmMecanise => {
  let result: boolean = false
  if (Array.isArray(contenu)) {
    result = contenu.some(({ id, elements }) => id === 'arm' && elements.some(({ id: idElement, value }) => idElement === 'mecanise' && value === true))
  } else {
    result = contenu['arm']?.['mecanise']?.value === true
  }

  return isArmMecaniseValidator.parse(result)
}
