import { Journal } from 'camino-common/src/journaux'
import { PureJournaux } from './journaux'
import { Meta, StoryFn } from '@storybook/vue3'
import { ApiClient } from '@/api/api-client'
import { action } from '@storybook/addon-actions'
import { CaminoRouteLocation } from '@/router/routes'
import { CaminoRouter } from '@/typings/vue-router'

const meta: Meta = {
  title: 'Components/Journaux',
  // @ts-ignore @storybook/vue3 n'aime pas les composants tsx
  component: PureJournaux,
}
export default meta

const element: Journal = {
  id: 'unIdDeJournal',
  date: '1662543155251',
  differences: null,
  elementId: 'unIdDelement',
  operation: 'create',
  utilisateur: {
    nom: 'Nom de famille',
    prenom: 'Le beau prénom',
  },
  titre: {
    nom: 'Le nom du titre concerné',
  },
}

const updateUrlQueryAction = action('updateUrlQuery')
const apiClient: Pick<ApiClient, 'titresRechercherByNom' | 'getTitresByIds' | 'getJournaux'> = {
  titresRechercherByNom: () => {
    return Promise.resolve({ elements: [] })
  },
  getTitresByIds: () => {
    return Promise.resolve({ elements: [] })
  },
  getJournaux: async () => {
    return {
      elements: [element],
      intervalle: 10,
      page: 1,
      total: 1,
    }
  },
}
const currentRoute: CaminoRouteLocation = { name: 'journaux', params: {}, query: {} }
const updateUrlQuery: Pick<CaminoRouter, 'push'> = {
  push: value => {
    updateUrlQueryAction(value)
    return Promise.resolve()
  },
}
export const Loading: StoryFn = () => <PureJournaux currentRoute={currentRoute} updateUrlQuery={updateUrlQuery} apiClient={{ ...apiClient, getJournaux: () => new Promise(() => ({})) }} />
export const WithError: StoryFn = () => (
  <PureJournaux currentRoute={currentRoute} updateUrlQuery={updateUrlQuery} apiClient={{ ...apiClient, getJournaux: () => Promise.reject(new Error('erreur')) }} />
)
export const Default: StoryFn = () => <PureJournaux currentRoute={currentRoute} updateUrlQuery={updateUrlQuery} apiClient={apiClient} />

export const AvecPagination: StoryFn = () => (
  <PureJournaux
    currentRoute={currentRoute}
    updateUrlQuery={updateUrlQuery}
    apiClient={{
      ...apiClient,
      getJournaux: async () => {
        return {
          elements: [...Array(10)].map(() => element),
          intervalle: 10,
          page: 1,
          total: 15,
        }
      },
    }}
  />
)
