import { Meta, StoryFn } from '@storybook/vue3'
import { PurePage } from './page'
import { action } from '@storybook/addon-actions'
import { ApiClient } from '@/api/api-client'
import { demarcheSlugValidator } from 'camino-common/src/demarche'
import { CaminoRouter } from '@/typings/vue-router'
import { routesDefinitions } from '@/router/routes'

const meta: Meta = {
  title: 'Components/Demarches/Page',
  // @ts-ignore @storybook/vue3 n'aime pas les composants tsx
  component: PurePage,
}
export default meta

const getDemarchesAction = action('getDemarches')
const pushRouteAction = action('pushRoute')

const updateUrlQuery: Pick<CaminoRouter, 'push'> = { push: values => Promise.resolve(pushRouteAction(values)) }

const apiClient: Pick<ApiClient, 'getDemarches' | 'titresRechercherByNom' | 'getTitresByIds'> = {
  titresRechercherByNom: () => {
    return Promise.resolve({ elements: [] })
  },
  getTitresByIds: () => {
    return Promise.resolve({ elements: [] })
  },
  getDemarches: () => {
    getDemarchesAction()

    return Promise.resolve({
      total: 1200,
      elements: [...Array(10).keys()].map(value => ({
        id: `id${value}`,
        slug: demarcheSlugValidator.parse(`slug${value}`),
        typeId: value % 2 === 0 ? 'dam' : 'amo',
        statutId: value % 2 === 0 ? 'fpm' : 'des',
        titre: {
          slug: `slug-${value}`,
          titreStatutId: value % 3 === 0 ? 'ech' : 'val',
          typeId: value % 3 === 0 ? 'cxm' : 'prg',
          nom: `Nom ${value}`,
          references: [
            {
              referenceTypeId: 'rnt',
              nom: `Ref ${value}`,
            },
          ],
        },
      })),
    })
  },
}

export const Loading: StoryFn = () => (
  <PurePage
    travaux
    updateUrlQuery={updateUrlQuery}
    entreprises={[]}
    currentRoute={{ name: 'demarches', query: { titresIds: ['id1'] }, params: {} }}
    apiClient={{ ...apiClient, getDemarches: () => new Promise(() => ({})), getTitresByIds: () => new Promise(() => ({})) }}
    filtres={routesDefinitions.demarches.meta.filtres}
  />
)

export const Travaux: StoryFn = () => (
  <PurePage
    travaux
    entreprises={[]}
    updateUrlQuery={updateUrlQuery}
    currentRoute={{ name: 'demarches', query: {}, params: {} }}
    apiClient={apiClient}
    filtres={routesDefinitions.travaux.meta.filtres}
  />
)

export const Demarches: StoryFn = () => (
  <PurePage
    travaux={false}
    entreprises={[]}
    updateUrlQuery={updateUrlQuery}
    currentRoute={{ name: 'demarches', query: {}, params: {} }}
    apiClient={apiClient}
    filtres={routesDefinitions.demarches.meta.filtres}
  />
)

export const WithError: StoryFn = () => (
  <PurePage
    travaux
    updateUrlQuery={updateUrlQuery}
    entreprises={[]}
    currentRoute={{ name: 'demarches', query: { titresIds: ['id1'] }, params: {} }}
    apiClient={{ ...apiClient, getTitresByIds: () => Promise.reject(new Error('Cassé')), getDemarches: () => Promise.reject(new Error('Cassé')) }}
    filtres={routesDefinitions.demarches.meta.filtres}
  />
)
