import { action } from '@storybook/addon-actions'
import { Meta, StoryFn } from '@storybook/vue3'
import { RemoveEtapePopup } from './remove-etape-popup'
import { etapeIdValidator } from 'camino-common/src/etape'
import { DEMARCHES_TYPES_IDS } from 'camino-common/src/static/demarchesTypes'
import { ETAPES_TYPES } from 'camino-common/src/static/etapesTypes'
import { TITRES_TYPES_IDS } from 'camino-common/src/static/titresTypes'

const meta: Meta = {
  title: 'Components/Demarche/RemoveEtapePopup',
  component: RemoveEtapePopup,
  argTypes: {},
}
export default meta

const deleteEtape = action('deleteEtape')
const close = action('close')

export const Default: StoryFn = () => (
  <RemoveEtapePopup
    demarcheTypeId={DEMARCHES_TYPES_IDS.Octroi}
    etapeTypeId={ETAPES_TYPES.demande}
    titreTypeId={TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX}
    id={etapeIdValidator.parse('etapeId')}
    apiClient={{
      deleteEtape(titreEtapeId) {
        deleteEtape(titreEtapeId)

        return Promise.resolve()
      },
    }}
    titreNom="Nouvelle espérance"
    close={close}
  />
)

export const WithError: StoryFn = () => (
  <RemoveEtapePopup
    demarcheTypeId={DEMARCHES_TYPES_IDS.Octroi}
    etapeTypeId={ETAPES_TYPES.demande}
    titreTypeId={TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX}
    id={etapeIdValidator.parse('etapeId')}
    apiClient={{
      deleteEtape(titreEtapeId) {
        deleteEtape(titreEtapeId)

        return Promise.resolve({
          message: 'Ceci est une erreur',
          detail: `Ceci est un détail d'erreur`,
        })
      },
    }}
    titreNom="Nouvelle espérance"
    close={close}
  />
)
