import { DEMARCHES_TYPES_IDS, DemarcheTypeId, TravauxIds } from '../demarchesTypes'
import { ETAPES_TYPES, EtapeTypeId } from '../etapesTypes'
import { TITRES_TYPES_IDS, TitreTypeId } from '../titresTypes'
import { TitresTypesDemarchesTypes } from '../titresTypesDemarchesTypes'

const travaux = {
  [DEMARCHES_TYPES_IDS.AutorisationDOuvertureDeTravaux]: [
    ETAPES_TYPES.demandeDautorisationDouvertureDeTravauxMiniers_AOTM_,
    ETAPES_TYPES.depotDeLaDemande_wdd,
    ETAPES_TYPES.demandeDeComplements_AOTMOuDOTM_,
    ETAPES_TYPES.receptionDeComplements_wrc,
    ETAPES_TYPES.recevabiliteDeLaDemande,
    ETAPES_TYPES.avisDeReception,
    ETAPES_TYPES.saisineDeLautoriteEnvironnementale,
    ETAPES_TYPES.avisDeLautoriteEnvironnementale,
    ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
    ETAPES_TYPES.enquetePublique,
    ETAPES_TYPES.rapportEtAvisDeLaDREAL,
    ETAPES_TYPES.transmissionDuProjetDePrescriptionsAuDemandeur,
    ETAPES_TYPES.avisDuDemandeurSurLesPrescriptionsProposees,
    ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
    ETAPES_TYPES.desistementDuDemandeur,
    ETAPES_TYPES.decisionDeLAutoriteAdministrative,
    ETAPES_TYPES.arreteDouvertureDesTravauxMiniers,
  ],
  [DEMARCHES_TYPES_IDS.DeclarationDOuvertureDeTravaux]: [
    ETAPES_TYPES.declarationDouvertureDeTravauxMiniers_DOTM_,
    ETAPES_TYPES.depotDeLaDemande_wdd,
    ETAPES_TYPES.demandeDeComplements_AOTMOuDOTM_,
    ETAPES_TYPES.receptionDeComplements_wrc,
    ETAPES_TYPES.recevabiliteDeLaDemande,
    ETAPES_TYPES.avisDeReception,
    ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
    ETAPES_TYPES.rapportEtAvisDeLaDREAL,
    ETAPES_TYPES.transmissionDuProjetDePrescriptionsAuDemandeur,
    ETAPES_TYPES.avisDuDemandeurSurLesPrescriptionsProposees,
    ETAPES_TYPES.donneActeDeLaDeclaration_DOTM_,
    ETAPES_TYPES.desistementDuDemandeur,
  ],
  [DEMARCHES_TYPES_IDS.DeclarationDArretDefinitifDesTravaux]: [
    ETAPES_TYPES.declarationDarretDefinitifDeTravaux_DADT_,
    ETAPES_TYPES.depotDeLaDemande_wdd,
    ETAPES_TYPES.demandeDeComplements_DADT_,
    ETAPES_TYPES.receptionDeComplements_wrc,
    ETAPES_TYPES.recevabiliteDeLaDemande,
    ETAPES_TYPES.avisDeReception,
    ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
    ETAPES_TYPES.arretePrefectoralDeSursisAStatuer,
    ETAPES_TYPES.transmissionDuProjetDePrescriptionsAuDemandeur,
    ETAPES_TYPES.avisDuDemandeurSurLesPrescriptionsProposees,
    ETAPES_TYPES.rapportEtAvisDeLaDREAL,
    ETAPES_TYPES.arretePrefectoralDePremierDonnerActe_DADT_,
    ETAPES_TYPES.arreteDePrescriptionsComplementaires,
    ETAPES_TYPES.memoireDeFinDeTravaux,
    ETAPES_TYPES.recolement,
    ETAPES_TYPES.arreteDeSecondDonnerActe,
    ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
    ETAPES_TYPES.porterAConnaissance,
  ],
} as const satisfies { [key in TravauxIds]: readonly EtapeTypeId[] }

const permisExclusifDeRecherchesMetauxEtGranulatsMarinsProlongationsEtapes = [
  ETAPES_TYPES.demande,
  ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
  ETAPES_TYPES.enregistrementDeLaDemande,
  ETAPES_TYPES.saisineDuPrefet,
  ETAPES_TYPES.desistementDuDemandeur,
  ETAPES_TYPES.modificationDeLaDemande,
  ETAPES_TYPES.recevabiliteDeLaDemande,
  ETAPES_TYPES.demandeDeComplements,
  ETAPES_TYPES.receptionDeComplements,
  ETAPES_TYPES.demandeDinformations,
  ETAPES_TYPES.receptionDinformation,
  ETAPES_TYPES.consultationDuPublic,
  ETAPES_TYPES.rapportEtAvisDeLaDREAL,
  ETAPES_TYPES.saisinesEtAvisCGE_AE,
  ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
  ETAPES_TYPES.avisDuPrefet,
  ETAPES_TYPES.saisineDeLautoriteSignataire,
  ETAPES_TYPES.decisionDeLAutoriteAdministrative,
  ETAPES_TYPES.publicationDeDecisionAuJORF,
  ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
  ETAPES_TYPES.publicationDansUnJournalLocalOuNational,
  ETAPES_TYPES.notificationAuDemandeur,
  ETAPES_TYPES.abrogationDeLaDecision,
  ETAPES_TYPES.decisionDuJugeAdministratif,
  ETAPES_TYPES.classementSansSuite,
] as const
const permisExclusifDeRecherchesMetauxEtGranulatsMarinsProlongations = {
  [DEMARCHES_TYPES_IDS.Prolongation2]: permisExclusifDeRecherchesMetauxEtGranulatsMarinsProlongationsEtapes,
  [DEMARCHES_TYPES_IDS.Prolongation1]: permisExclusifDeRecherchesMetauxEtGranulatsMarinsProlongationsEtapes,
} as const

const permisExploitationMetauxEtGranulatsMarinsProlongationsEtapes = [
  ETAPES_TYPES.demande,
  ETAPES_TYPES.enregistrementDeLaDemande,
  ETAPES_TYPES.modificationDeLaDemande,
  ETAPES_TYPES.desistementDuDemandeur,
  ETAPES_TYPES.saisineDuPrefet,
  ETAPES_TYPES.demandeDeComplements,
  ETAPES_TYPES.receptionDeComplements,
  ETAPES_TYPES.demandeDinformations,
  ETAPES_TYPES.receptionDinformation,
  ETAPES_TYPES.recevabiliteDeLaDemande,
  ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
  ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
  ETAPES_TYPES.avisDesCollectivites,
  ETAPES_TYPES.rapportEtAvisDeLaDREAL,
  ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
  ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
  ETAPES_TYPES.avisDuPrefet,
  ETAPES_TYPES.saisinesEtAvisCGE_AE,
  ETAPES_TYPES.saisineDeLautoriteSignataire,
  ETAPES_TYPES.decisionDeLAutoriteAdministrative,
  ETAPES_TYPES.publicationDeDecisionAuJORF,
  ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
  ETAPES_TYPES.notificationAuDemandeur,
  ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
  ETAPES_TYPES.notificationDesCollectivitesLocales,
  ETAPES_TYPES.abrogationDeLaDecision,
  ETAPES_TYPES.decisionDuJugeAdministratif,
  ETAPES_TYPES.classementSansSuite,
  ETAPES_TYPES.informationsHistoriquesIncompletes,
] as const
const permisExploitationMetauxEtGranulatsMarinsProlongations = {
  [DEMARCHES_TYPES_IDS.Prolongation1]: permisExploitationMetauxEtGranulatsMarinsProlongationsEtapes,
  [DEMARCHES_TYPES_IDS.Prolongation2]: permisExploitationMetauxEtGranulatsMarinsProlongationsEtapes,
} as const

const concessionHydrocarbureOctroiEtProlongation = [
  ETAPES_TYPES.demande,
  ETAPES_TYPES.enregistrementDeLaDemande,
  ETAPES_TYPES.saisineDuPrefet,
  ETAPES_TYPES.desistementDuDemandeur,
  ETAPES_TYPES.modificationDeLaDemande,
  ETAPES_TYPES.demandeDeComplements,
  ETAPES_TYPES.receptionDeComplements,
  ETAPES_TYPES.demandeDinformations,
  ETAPES_TYPES.receptionDinformation,
  ETAPES_TYPES.recevabiliteDeLaDemande,
  ETAPES_TYPES.avisDeDemandeConcurrente,
  ETAPES_TYPES.enquetePublique,
  ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
  ETAPES_TYPES.avisDesCollectivites,
  ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
  ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
  ETAPES_TYPES.rapportEtAvisDeLaDREAL,
  ETAPES_TYPES.avisDuPrefet,
  ETAPES_TYPES.saisinesEtAvisCGE_AE,
  ETAPES_TYPES.saisineDuConseilDEtat,
  ETAPES_TYPES.rapportDuConseilDEtat,
  ETAPES_TYPES.avisDuConseilDEtat,
  ETAPES_TYPES.saisineDeLautoriteSignataire,
  ETAPES_TYPES.decisionDeLAutoriteAdministrative,
  ETAPES_TYPES.publicationDeDecisionAuJORF,
  ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
  ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
  ETAPES_TYPES.notificationAuDemandeur,
  ETAPES_TYPES.notificationDesCollectivitesLocales,
  ETAPES_TYPES.abrogationDeLaDecision,
  ETAPES_TYPES.decisionDuJugeAdministratif,
  ETAPES_TYPES.consultationDuPublic,
  ETAPES_TYPES.classementSansSuite,
] as const

const permisExclusifDeRechercheSouterrain = [
  ETAPES_TYPES.demande,
  ETAPES_TYPES.enregistrementDeLaDemande,
  ETAPES_TYPES.saisineDuPrefet,
  ETAPES_TYPES.desistementDuDemandeur,
  ETAPES_TYPES.modificationDeLaDemande,
  ETAPES_TYPES.demandeDeComplements,
  ETAPES_TYPES.receptionDeComplements,
  ETAPES_TYPES.demandeDinformations,
  ETAPES_TYPES.receptionDinformation,
  ETAPES_TYPES.recevabiliteDeLaDemande,
  ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
  ETAPES_TYPES.avisDeDemandeConcurrente,
  ETAPES_TYPES.consultationDuPublic,
  ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
  ETAPES_TYPES.avisDesCollectivites,
  ETAPES_TYPES.rapportEtAvisDeLaDREAL,
  ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
  ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
  ETAPES_TYPES.avisDuPrefet,
  ETAPES_TYPES.saisinesEtAvisCGE_AE,
  ETAPES_TYPES.saisineDeLautoriteSignataire,
  ETAPES_TYPES.decisionDeLAutoriteAdministrative,
  ETAPES_TYPES.publicationDeDecisionAuJORF,
  ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
  ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
  ETAPES_TYPES.notificationAuDemandeur,
  ETAPES_TYPES.notificationDesCollectivitesLocales,
  ETAPES_TYPES.abrogationDeLaDecision,
  ETAPES_TYPES.decisionDuJugeAdministratif,
  ETAPES_TYPES.classementSansSuite,
] as const

const permisExclusifRechercheGeothermieOctroiEtProlongationsEtapes = [
  ETAPES_TYPES.demande,
  ETAPES_TYPES.enregistrementDeLaDemande,
  ETAPES_TYPES.recevabiliteDeLaDemande,
  ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
  ETAPES_TYPES.avisDeDemandeConcurrente,
  ETAPES_TYPES.modificationDeLaDemande,
  ETAPES_TYPES.saisineDuPrefet,
  ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
  ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
  ETAPES_TYPES.saisineDeLautoriteSignataire,
  ETAPES_TYPES.consultationDuPublic,
  ETAPES_TYPES.saisinesEtAvisCGE_AE,
  ETAPES_TYPES.avisDesCollectivites,
  ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
  ETAPES_TYPES.avisDuPrefet,
  ETAPES_TYPES.decisionDeLAutoriteAdministrative,
  ETAPES_TYPES.publicationDeDecisionAuJORF,
  ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
  ETAPES_TYPES.abrogationDeLaDecision,
  ETAPES_TYPES.decisionDuJugeAdministratif,
  ETAPES_TYPES.desistementDuDemandeur,
  ETAPES_TYPES.classementSansSuite,
]

const TDE = {
  [TITRES_TYPES_IDS.AUTORISATION_DE_PROSPECTION_CARRIERES]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.AUTORISATION_DE_PROSPECTION_HYDROCARBURE]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.AUTORISATION_DE_PROSPECTION_METAUX]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.AUTORISATION_DE_PROSPECTION_GRANULATS_MARINS]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_CARRIERES]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_GEOTHERMIE]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.AUTORISATION_DE_RECHERCHE_METAUX]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.receptionDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.decisionDeLOfficeNationalDesForets,
      ETAPES_TYPES.avenantALautorisationDeRechercheMiniere,
      ETAPES_TYPES.notificationAuDemandeur_AvisDefavorable_,
      ETAPES_TYPES.notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_,
      ETAPES_TYPES.notificationAuDemandeur_ClassementSansSuite_,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.receptionDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.avenantALautorisationDeRechercheMiniere,
      ETAPES_TYPES.notificationAuDemandeur_AvisDefavorable_,
      ETAPES_TYPES.notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_,
      ETAPES_TYPES.notificationAuDemandeur_ClassementSansSuite_,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.receptionDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.avenantALautorisationDeRechercheMiniere,
      ETAPES_TYPES.notificationAuDemandeur_AvisDefavorable_,
      ETAPES_TYPES.notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_,
      ETAPES_TYPES.notificationAuDemandeur_ClassementSansSuite_,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.notificationAuDemandeur_InitiationDeLaDemarcheDeRetrait_,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avenantALautorisationDeRechercheMiniere,
      ETAPES_TYPES.notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.notificationAuDemandeur_ClassementSansSuite_,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.receptionDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet__,
      ETAPES_TYPES.receptionDeComplements_RecepisseDeDeclarationLoiSurLeau_,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.demandeDeComplements_DecisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_,
      ETAPES_TYPES.demandeDeComplements_RecepisseDeDeclarationLoiSurLeau_,
      ETAPES_TYPES.decisionDeLaMissionAutoriteEnvironnementale_ExamenAuCasParCasDuProjet_,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.paiementDesFraisDeDossier,
      ETAPES_TYPES.validationDuPaiementDesFraisDeDossier,
      ETAPES_TYPES.completudeDeLaDemande,
      ETAPES_TYPES.demandeDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.demandeDeComplements_CompletudeDeLaDemande_,
      ETAPES_TYPES.receptionDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.receptionDeComplements_CompletudeDeLaDemande_,
      ETAPES_TYPES.demandeDinformations_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.priseEnChargeParLOfficeNationalDesForets,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.expertises,
      ETAPES_TYPES.notificationAuDemandeur_ClassementSansSuite_,
      ETAPES_TYPES.recepisseDeDeclarationLoiSurLeau,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.demandeDeComplements_SaisineDeLaCARM_,
      ETAPES_TYPES.receptionDeComplements_SaisineDeLaCARM_,
      ETAPES_TYPES.saisineDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_,
      ETAPES_TYPES.avisDeLaCommissionDesAutorisationsDeRecherchesMinieres_CARM_,
      ETAPES_TYPES.notificationAuDemandeur_AjournementDeLaCARM_,
      ETAPES_TYPES.notificationAuDemandeur_AvisDefavorable_,
      ETAPES_TYPES.notificationAuDemandeur_AvisFavorableDeLaCARM_,
      ETAPES_TYPES.paiementDesFraisDeDossierComplementaires,
      ETAPES_TYPES.validationDuPaiementDesFraisDeDossierComplementaires,
      ETAPES_TYPES.decisionDeLOfficeNationalDesForets,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.signatureDeLautorisationDeRechercheMiniere,
      ETAPES_TYPES.notificationAuDemandeur_SignatureDeLautorisationDeRechercheMiniere_,
      ETAPES_TYPES.avenantALautorisationDeRechercheMiniere,
      ETAPES_TYPES.notificationAuDemandeur_SignatureDeLavenantALautorisationDeRechercheMiniere_,
    ],
  },
  [TITRES_TYPES_IDS.AUTORISATION_D_EXPLOITATION_METAUX]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.demandeDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.receptionDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.demandeDinformations_AvisDuDREALDEALOuDGTM_,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.publicationDansUnJournalLocalOuNational,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.informationsHistoriquesIncompletes,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.CONCESSION_FOSSILES]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDuConseilDEtat,
      ETAPES_TYPES.rapportDuConseilDEtat,
      ETAPES_TYPES.avisDuConseilDEtat,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [ETAPES_TYPES.saisineDuPrefet, ETAPES_TYPES.decisionDeLAutoriteAdministrative, ETAPES_TYPES.publicationDeDecisionAuJORF, ETAPES_TYPES.classementSansSuite],
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.CONCESSION_GEOTHERMIE]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDuConseilDEtat,
      ETAPES_TYPES.rapportDuConseilDEtat,
      ETAPES_TYPES.avisDuConseilDEtat,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.CONCESSION_HYDROCARBURE]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Conversion]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: concessionHydrocarbureOctroiEtProlongation,
    [DEMARCHES_TYPES_IDS.Prolongation]: concessionHydrocarbureOctroiEtProlongation,
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [ETAPES_TYPES.saisineDuPrefet, ETAPES_TYPES.decisionDeLAutoriteAdministrative, ETAPES_TYPES.publicationDeDecisionAuJORF, ETAPES_TYPES.classementSansSuite],
  },
  [TITRES_TYPES_IDS.CONCESSION_METAUX]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.MutationPartielle]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.consultationDuPublic,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDuConseilDEtat,
      ETAPES_TYPES.rapportDuConseilDEtat,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.publicationDansUnJournalLocalOuNational,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.avisDuConseilDEtat,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.publicationDansUnJournalLocalOuNational,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.publicationDansUnJournalLocalOuNational,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Cession]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Decheance]: [
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Fusion]: [ETAPES_TYPES.decisionDeLAutoriteAdministrative, ETAPES_TYPES.publicationDeDecisionAuJORF],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.consultationDuPublic,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDuConseilDEtat,
      ETAPES_TYPES.rapportDuConseilDEtat,
      ETAPES_TYPES.avisDuConseilDEtat,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.publicationDansUnJournalLocalOuNational,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.CONCESSION_RADIOACTIF]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDuConseilDEtat,
      ETAPES_TYPES.rapportDuConseilDEtat,
      ETAPES_TYPES.avisDuConseilDEtat,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [ETAPES_TYPES.saisineDuPrefet, ETAPES_TYPES.decisionDeLAutoriteAdministrative, ETAPES_TYPES.publicationDeDecisionAuJORF, ETAPES_TYPES.classementSansSuite],
  },
  [TITRES_TYPES_IDS.CONCESSION_SOUTERRAIN]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDuConseilDEtat,
      ETAPES_TYPES.rapportDuConseilDEtat,
      ETAPES_TYPES.avisDuConseilDEtat,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [ETAPES_TYPES.saisineDuPrefet, ETAPES_TYPES.decisionDeLAutoriteAdministrative, ETAPES_TYPES.publicationDeDecisionAuJORF, ETAPES_TYPES.classementSansSuite],
  },
  [TITRES_TYPES_IDS.CONCESSION_GRANULATS_MARINS]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.consultationDesAdministrationsCentrales,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDuConseilDEtat,
      ETAPES_TYPES.rapportDuConseilDEtat,
      ETAPES_TYPES.avisDuConseilDEtat,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.informationsHistoriquesIncompletes,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.consultationDuPublic,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.consultationDesAdministrationsCentrales,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDuConseilDEtat,
      ETAPES_TYPES.rapportDuConseilDEtat,
      ETAPES_TYPES.avisDuConseilDEtat,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.informationsHistoriquesIncompletes,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.INDETERMINE_METAUX]: { [DEMARCHES_TYPES_IDS.Octroi]: [ETAPES_TYPES.informationsHistoriquesIncompletes] },
  [TITRES_TYPES_IDS.INDETERMINE_RADIOACTIF]: { [DEMARCHES_TYPES_IDS.Octroi]: [ETAPES_TYPES.informationsHistoriquesIncompletes] },
  [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_CARRIERES_CARRIERES]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [ETAPES_TYPES.saisineDuPrefet, ETAPES_TYPES.decisionDeLAutoriteAdministrative, ETAPES_TYPES.publicationDeDecisionAuJORF],
  },
  [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_FOSSILES]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Fusion]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.consultationDuPublic,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation1]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation2]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_GEOTHERMIE]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Fusion]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: permisExclusifRechercheGeothermieOctroiEtProlongationsEtapes,
    [DEMARCHES_TYPES_IDS.MutationPartielle]: [
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation1]: permisExclusifRechercheGeothermieOctroiEtProlongationsEtapes,
    [DEMARCHES_TYPES_IDS.Prolongation2]: permisExclusifRechercheGeothermieOctroiEtProlongationsEtapes,
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_HYDROCARBURE]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Fusion]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation1]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation2]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ProlongationExceptionnelle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_METAUX]: {
    ...travaux,
    ...permisExclusifDeRecherchesMetauxEtGranulatsMarinsProlongations,
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Fusion]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDeSubstance]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.receptionDeComplements_RecevabiliteDeLaDemande_,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.expertises,
      ETAPES_TYPES.consultationDuPublic,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.publicationDansUnJournalLocalOuNational,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.informationsHistoriquesIncompletes,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_RADIOACTIF]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.ExtensionDeSubstance]: [ETAPES_TYPES.decisionDeLAutoriteAdministrative, ETAPES_TYPES.publicationDeDecisionAuJORF],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Fusion]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.consultationDuPublic,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prorogation]: [ETAPES_TYPES.decisionDeLAutoriteAdministrative, ETAPES_TYPES.publicationDeDecisionAuJORF],
    [DEMARCHES_TYPES_IDS.Prolongation1]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation2]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_SOUTERRAIN]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Fusion]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: permisExclusifDeRechercheSouterrain,
    [DEMARCHES_TYPES_IDS.Prolongation1]: permisExclusifDeRechercheSouterrain,
    [DEMARCHES_TYPES_IDS.Prolongation2]: permisExclusifDeRechercheSouterrain,
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_EXCLUSIF_DE_RECHERCHES_GRANULATS_MARINS]: {
    ...travaux,
    ...permisExclusifDeRecherchesMetauxEtGranulatsMarinsProlongations,
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.consultationDuPublic,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.consultationDesAdministrationsCentrales,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Fusion]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_D_EXPLOITATION_GEOTHERMIE]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Fusion]: [
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_D_EXPLOITATION_FOSSILES]: {
    [DEMARCHES_TYPES_IDS.Octroi]: [ETAPES_TYPES.publicationDeDecisionAuJORF],
  },
  [TITRES_TYPES_IDS.PERMIS_D_EXPLOITATION_HYDROCARBURE]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation1]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation2]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prorogation]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_D_EXPLOITATION_METAUX]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.receptionDeComplements,
      ETAPES_TYPES.demandeDinformations,
      ETAPES_TYPES.receptionDinformation,
      ETAPES_TYPES.recevabiliteDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.avisDeMiseEnConcurrenceAuJORF,
      ETAPES_TYPES.avisDeDemandeConcurrente,
      ETAPES_TYPES.enquetePublique,
      ETAPES_TYPES.avisDesServicesEtCommissionsConsultatives,
      ETAPES_TYPES.avisDesCollectivites,
      ETAPES_TYPES.rapportEtAvisDeLaDREAL,
      ETAPES_TYPES.saisineDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDeLaCommissionDepartementaleDesMines_CDM_,
      ETAPES_TYPES.avisDuPrefet,
      ETAPES_TYPES.saisinesEtAvisCGE_AE,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.informationDuPrefetEtDesCollectivites,
      ETAPES_TYPES.notificationAuDemandeur,
      ETAPES_TYPES.publicationDeDecisionAuRecueilDesActesAdministratifs,
      ETAPES_TYPES.notificationDesCollectivitesLocales,
      ETAPES_TYPES.publicationDansUnJournalLocalOuNational,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
      ETAPES_TYPES.informationsHistoriquesIncompletes,
    ],
    ...permisExploitationMetauxEtGranulatsMarinsProlongations,
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDeSubstance]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.desistementDuDemandeur,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.demandeDeComplements,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_D_EXPLOITATION_RADIOACTIF]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prorogation]: [ETAPES_TYPES.decisionDeLAutoriteAdministrative, ETAPES_TYPES.publicationDeDecisionAuJORF],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDeSubstance]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation1]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prolongation2]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.publicationDeLavisDeDecisionImplicite,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.DemandeDeTitreDExploitation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
  [TITRES_TYPES_IDS.PERMIS_D_EXPLOITATION_GRANULATS_MARINS]: {
    ...travaux,
    [DEMARCHES_TYPES_IDS.Amodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Octroi]: [
      ETAPES_TYPES.informationsHistoriquesIncompletes,
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.ExtensionDePerimetre]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationTotale]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.RenonciationPartielle]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Mutation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    ...permisExploitationMetauxEtGranulatsMarinsProlongations,
    [DEMARCHES_TYPES_IDS.ResiliationAnticipeeDAmodiation]: [
      ETAPES_TYPES.demande,
      ETAPES_TYPES.enregistrementDeLaDemande,
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.modificationDeLaDemande,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Retrait]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
    [DEMARCHES_TYPES_IDS.Prorogation]: [
      ETAPES_TYPES.saisineDuPrefet,
      ETAPES_TYPES.saisineDeLautoriteSignataire,
      ETAPES_TYPES.decisionDeLAutoriteAdministrative,
      ETAPES_TYPES.publicationDeDecisionAuJORF,
      ETAPES_TYPES.abrogationDeLaDecision,
      ETAPES_TYPES.decisionDuJugeAdministratif,
      ETAPES_TYPES.classementSansSuite,
    ],
  },
} as const satisfies { [key in TitreTypeId]: { [other in TitresTypesDemarchesTypes[key][number]]: readonly EtapeTypeId[] } }

export type TDEType = typeof TDE
type TDEDemarchesSubObject = (typeof TDE)[keyof typeof TDE]

const isDemarcheTypeFromTitreType = (demarches: TDEDemarchesSubObject, demarcheTypeId: DemarcheTypeId): demarcheTypeId is keyof TDEDemarchesSubObject => {
  return Object.keys(demarches).findIndex(demarcheId => demarcheId === demarcheTypeId) !== -1
}
export const getEtapesTDE = (titreTypeId: TitreTypeId, demarcheTypeId: DemarcheTypeId): readonly EtapeTypeId[] => {
  if (isDemarcheTypeFromTitreType(TDE[titreTypeId], demarcheTypeId)) {
    return TDE[titreTypeId][demarcheTypeId]
  }

  return []
}

export const isTDEExist = (titreTypeId: TitreTypeId, demarcheTypeId: DemarcheTypeId, etapeTypeId: EtapeTypeId): boolean => {
  if (isDemarcheTypeFromTitreType(TDE[titreTypeId], demarcheTypeId)) {
    return (TDE[titreTypeId][demarcheTypeId] as readonly EtapeTypeId[]).includes(etapeTypeId)
  }

  return false
}
