import { ElementWithValue } from '../sections'
import { isNullOrUndefined } from '../typescript-tools'

// @deprecated ==> type better
export type Contenu = { [key in string]?: { [secondKey in string]?: unknown } } | null

export const sectionsWithValueCompleteValidate = (sections_with_value: { nom?: string; elements: Pick<ElementWithValue, 'nom' | 'optionnel' | 'value' | 'type'>[] }[]): string[] => {
  const errors: string[] = []
  sections_with_value.forEach(s =>
    s.elements.forEach(e => {
      if (!sectionElementWithValueCompleteValidate(e)) {
        errors.push(`l'élément "${e.nom}" de la section "${s.nom}" est obligatoire`)
      }
    })
  )

  return errors
}

export const sectionElementWithValueCompleteValidate = (elementWithValue: Pick<ElementWithValue, 'optionnel' | 'value' | 'type'>): boolean => {
  if ((isNullOrUndefined(elementWithValue.optionnel) || !elementWithValue.optionnel) && !['checkbox'].includes(elementWithValue.type)) {
    if (isNullOrUndefined(elementWithValue.value) || elementWithValue.value === '') {
      return false
    }
  }

  return true
}
