import { test, expect } from 'vitest'
import { crsUrnValidator, equalGeojson, featureMultiPolygonValidator } from './perimetre'

test('equalGeojson', () => {
  expect(equalGeojson(null, null)).toBe(true)
  expect(equalGeojson(null, { type: 'MultiPolygon', coordinates: [[[[1, 2]]]] })).toBe(false)
  expect(equalGeojson({ type: 'MultiPolygon', coordinates: [[[[1, 2]]]] }, null)).toBe(false)
  expect(equalGeojson({ type: 'MultiPolygon', coordinates: [[[[1, 2]]]] }, undefined)).toBe(false)
  expect(equalGeojson({ type: 'MultiPolygon', coordinates: [[[[1, 2]]]] }, { type: 'MultiPolygon', coordinates: [[[[2, 2]]]] })).toBe(false)
  expect(
    equalGeojson(
      { type: 'MultiPolygon', coordinates: [[[[1, 2]]]] },
      {
        type: 'MultiPolygon',
        coordinates: [
          [
            [
              [2, 2],
              [1, 2],
            ],
          ],
        ],
      }
    )
  ).toBe(false)
  expect(
    equalGeojson(
      {
        type: 'MultiPolygon',
        coordinates: [
          [
            [
              [1, 2],
              [1, 2],
            ],
          ],
        ],
      },
      { type: 'MultiPolygon', coordinates: [[[[1, 2]]]] }
    )
  ).toBe(false)
  expect(equalGeojson({ type: 'MultiPolygon', coordinates: [[[[1, 2]]]] }, { type: 'MultiPolygon', coordinates: [[[[1, 2]]]] })).toBe(true)
})

test('crsUrnValidator', () => {
  expect(crsUrnValidator.safeParse('').success).toBe(false)
  expect(crsUrnValidator.safeParse('urn:ogc:def:crs:EPSG::2972').success).toBe(true)
  expect(crsUrnValidator.safeParse('urn:ogc:def:crs:OGC::CRS84').success).toBe(true)
  expect(crsUrnValidator.safeParse('urn:ogc:def:crs:OGC:1.3:CRS84').success).toBe(true)
  expect(crsUrnValidator.safeParse('urn:ogc:def:crs:EPSG:1.32:2972').success).toBe(true)
  expect(crsUrnValidator.safeParse('urn:ogc:def:crs:EPSG::PLOP').success).toBe(false)
  expect(crsUrnValidator.safeParse('urn:ogc:def:crs:EPSG::').success).toBe(false)
  expect(crsUrnValidator.safeParse('urn:ogc:def:crs:EPSG::27572').success).toBe(true)
  expect(crsUrnValidator.safeParse(12).success).toBe(false)
})

test('nullableToEmptyObject', () => {
  featureMultiPolygonValidator.parse({
    type: 'Feature',
    properties: null,
    geometry: {
      type: 'MultiPolygon',
      coordinates: [
        [
          [
            [1, 2],
            [1, 2],
            [1, 2],
          ],
        ],
      ],
    },
  })
  featureMultiPolygonValidator.parse({
    type: 'Feature',
    properties: {},
    geometry: {
      type: 'MultiPolygon',
      coordinates: [
        [
          [
            [1, 2],
            [1, 2],
            [1, 2],
          ],
        ],
      ],
    },
  })
})
