import '../init'
import pg from 'pg'
import { config } from '../config'
import { checkProlongations } from '../business/check-prolongations'
import { Effect } from 'effect'

const pool = new pg.Pool({
  host: config().PGHOST,
  user: config().PGUSER,
  password: config().PGPASSWORD,
  database: config().PGDATABASE,
})

Effect.runPromiseExit(checkProlongations(pool))
  .then(() => process.exit(0))
  .catch(reason => {
    console.error(reason)
    process.exit(1)
  })
