import { Knex } from 'knex'

export const up = async (knex: Knex): Promise<void> => {
  await knex.raw('CREATE EXTENSION unaccent')
  await knex.raw(`CREATE OR REPLACE FUNCTION my_unaccent(some_time varchar)
    RETURNS text
  AS
  $BODY$
      select unaccent($1);
  $BODY$
  LANGUAGE sql
  IMMUTABLE;`)
  await knex.raw('CREATE INDEX ON titres (lower(my_unaccent(nom)));')
}

export const down = (): void => {}
